define({"0":{y:0,u:"../Content/Tutorial/Introduction.htm",l:-1,t:"Introduction",i:0.00331729260366823,a:"Connectors provide the connection between IDOL and the repositories that your organization uses for storing and organizing information. You can use connectors to keep your IDOL index up-to-date with the information in a repository (using the synchronize fetch action) and to retrieve files, or lists ..."},"1":{y:0,u:"../Content/ConnectorLib_Tutorial.htm",l:-1,t:"ConnectorLib .NET Tutorial",i:0.000497602889741495,a:"ConnectorLib .NET Tutorial This section shows how to use the ConnectorLib .NET SDK to build a connector."},"2":{y:0,u:"../Content/Tutorial/Implement.htm",l:-1,t:"Implement a New Connector",i:0.00118139283821155,a:"Implement a New Connector This section describes how to implement a new connector."},"3":{y:0,u:"../Content/Tutorial/Create_the_Visual_Studio.htm",l:-1,t:"Create the Visual Studio Solution",i:0.000497602889741495,a:"To create a new connector using Visual Studio, create a new solution containing a class library project. The class library will contain the code for your connector. Next, select the project and add a reference to DotNetConnector.dll. You are now ready to start writing the connector."},"4":{y:0,u:"../Content/Tutorial/Extend_ConnectorBase.htm",l:-1,t:"Extend ConnectorBase",i:0.000497602889741495,a:"To create a new connector you must create a class that extends the Autonomy.Connector.ConnectorBase class. For example: \nusing System;\nusing Autonomy.Connector;\n\nnamespace MyConnectorNamespace\n{\n\tpublic class MyConnector : ConnectorBase\n\t{\n\t\tpublic MyConnector(IConfig config, ILog log) :\n\t\t    ..."},"5":{y:0,u:"../Content/Tutorial/RunConnector/Run_Introduction.htm",l:-1,t:"Run the Connector",i:0.00134352845413372,a:"Run the Connector This section describes how to run a new connector."},"6":{y:0,u:"../Content/Tutorial/RunConnector/Required_Files.htm",l:-1,t:"Required Files",i:0.000638590483806866,a:"To run the connector, you must place the following files in a directory (from now on called the connector directory). All of the files, except your connector  DLL , are provided with the SDK. Your connector  DLL , and any dependencies connectorLibDotNet.cfg connectorLibDotNet.exe DotNetConnector.dll ..."},"7":{y:0,u:"../Content/Tutorial/RunConnector/Configure.htm",l:-1,t:"Configure the Connector",i:0.000638590483806866,a:"Before running the connector you must modify  connectorLibDotNet.cfg . In the [Connector] section of the configuration file, set the following parameters. These parameters tell ConnectorLib .NET how to locate your connector implementation: For example, this is the configuration for the HelloWorld ..."},"8":{y:0,u:"../Content/Tutorial/RunConnector/RunConnector.htm",l:-1,t:"Run the Connector",i:0.000497602889741495,a:"After you have collected the  required files  and  configured the connector , you can run the connector by starting  connectorLibDotNet.exe . View Log Messages Any log messages produced by your connector implementation appear in the appropriate log file.  For example, in the HelloWorld connector ..."},"9":{y:0,u:"../Content/Tutorial/RunConnector/Troubleshooting.htm",l:-1,t:"Troubleshoot Errors",i:0.000497602889741495,a:"If you run the connector and find that it stops immediately, check the logs to see if any errors occurred at the time you tried to start it. You can also try running the connector from the command prompt to see if any messages are output to the console.  The following table provides the solutions ..."},"10":{y:0,u:"../Content/Tutorial/Documents/Documents_Introduction.htm",l:-1,t:"Create and Ingest Documents",i:0.000497602889741495,a:"Create and Ingest Documents This section describes how to create and ingest Documents using ConnectorLib .NET."},"11":{y:0,u:"../Content/Tutorial/Documents/Documents_Intro.htm",l:-1,t:"Introduction",i:0.000497602889741495,a:"Much of what a connector does involves dealing with documents in some way. A document represents a single document in IDOL and has: A unique reference to identify it. A unique identifier for finding it in the repository. A set of key-value pairs for storing metadata. Optionally, a file storing the ..."},"12":{y:0,u:"../Content/Tutorial/Documents/Create_a_Document.htm",l:-1,t:"Create a Document",i:0.000497602889741495,a:"With ConnectorLib .NET, you can create a new document using the DocInfo.Create() methods, for example: \n       IDocInfo doc = DocInfo.Create(task.TaskConfig,\n\t\t\"http://www.example.com/testDocument.doc\",\n\t\t\"testDocument.doc\", true); The arguments for this method are:        Create(ITaskConfig ..."},"13":{y:0,u:"../Content/Tutorial/Documents/Add_Metadata.htm",l:-1,t:"Add Metadata",i:0.000497602889741495,a:"Often repositories store metadata about the files they contain, such as who created a file and when it was last modified. Metadata might also include repository-specific information. For example, a repository storing information about products for sale might include a price and a description for ..."},"14":{y:0,u:"../Content/Tutorial/Documents/Metadata_only_Documents.htm",l:-1,t:"Create Metadata-only Documents",i:0.000497602889741495,a:"To create a document that has metadata but no file, use a different overload of DocInfo.Create:        IDocInfo doc = DocInfo.Create(task.TaskConfig,\n\t\t\"http://www.example.com/metadataOnly\"); You might create a metadata-only document when items in a repository do not include file data (for example, ..."},"15":{y:0,u:"../Content/Tutorial/Documents/Identifiers.htm",l:-1,t:"Create Identifiers",i:0.000497602889741495,a:"Although a document\u0027s reference should identify a unique file or item  in the repository, it might not be sufficient for the connector to retrieve it again efficiently (this might be necessary, for example, in response to a collect request). You can therefore add additional information to a ..."},"16":{y:0,u:"../Content/Tutorial/Documents/Ingest_a_Document.htm",l:-1,t:"Ingest a Document",i:0.000497602889741495,a:"A connector\u0027s synchronize action typically involves retrieving files and associated metadata from a repository, creating documents from those files, and sending the documents  to the ingestion target, configured in the [Ingestion] section of the configuration file. Usually the target is a CFS, which ..."},"17":{y:0,u:"../Content/Tutorial/Documents/Ingest_Add.htm",l:-1,t:"Ingest Add",i:0.00133295444320532,a:"The Ingest Add method adds a new document to the ingestion target. You can create and ingest a document  like this:        using(IDocInfo doc = DocInfo.Create(task.TaskConfig,\n               \"http://www.example.com/testDocument.doc\",\n               \"testDocument.doc\", true))\n       {\n           ..."},"18":{y:0,u:"../Content/Tutorial/Documents/Ingest_Remove.htm",l:-1,t:"Ingest Remove",i:0.00128167049541809,a:"The Remove method deletes a document that has previously been ingested. Only the reference is required to do this:        task.Ingester.Remove(\"http://www.example.com/testDocument.doc\"); The synchronize action typically removes documents when the connector detects that a document has been removed ..."},"19":{y:0,u:"../Content/Tutorial/Documents/Ingest_Replace.htm",l:-1,t:"Ingest Replace",i:0.000638590483806866,a:"The Replace method is short-hand for performing a  Remove  followed by an  Add. You can use this method when a document in a repository has been changed.        using(IDocInfo doc = DocInfo.Create(task.TaskConfig,\n               \"http://www.example.com/testDocument.doc\",\n               ..."},"20":{y:0,u:"../Content/Tutorial/Documents/Ingest_Update.htm",l:-1,t:"Ingest Update",i:0.000497602889741495,a:"If a document has been ingested previously, and the metadata for the document has changed but the file content has not, you can use the Ingest Update method. This instructs the target to update the metadata for an existing document, but to leave the content intact. The following example updates just ..."},"21":{y:0,u:"../Content/Tutorial/Documents/Ingest_Result_Handlers.htm",l:-1,t:"Ingest Result Handlers",i:0.000497602889741495,a:"When you ingest a document using the Add, Replace, Remove or Update methods, the ingest command is placed in a queue and the method returns immediately. ConnectorLib .NET takes care of batching, sending the commands, and dealing with any transitory problems communicating with the target. As a ..."},"22":{y:0,u:"../Content/Tutorial/CompleteSynchronize/Introduction.htm",l:-1,t:"A Complete Synchronize Action",i:0.00200423220813563,a:"This section demonstrates code for a connector\u0027s synchronize action. During a complete synchronize, a connector ingests every document in a repository, regardless of whether the documents have changed since the last synchronize. \n            The sample uses a directory on the file system to ..."},"23":{y:0,u:"../Content/Tutorial/CompleteSynchronize/SampleCode.htm",l:-1,t:"Sample Code for the Synchronize Action",i:0.00126836467218595,a:"The following code sample demonstrates a complete synchronize action. The sample uses a directory on the file system to represent a repository.        using System;\n       using System.IO;\n       using Autonomy.Connector;\n \n       namespace MyConnectorNamespace\n       {\n           public class ..."},"24":{y:0,u:"../Content/Tutorial/CompleteSynchronize/RunConnector.htm",l:-1,t:"Set up and Run the Connector",i:0.000497602889741495,a:"You can set up the connector using the instructions in  Run the Connector . SimpleSynchronize.dll must be in the connector directory, and you must set the following parameters in connectorLibDotNet.cfg:        DotNetConnectorLibrary=SimpleSynchronize.dll\n       ..."},"25":{y:0,u:"../Content/Tutorial/CompleteSynchronize/Stopping.htm",l:-1,t:"Handle Stop Requests",i:0.000497602889741495,a:"A connector can be requested to stop at any time.  For example,  the connector might be running as a service that is stopped, it might receive an action=stop command to its service port, or a user might press CTRL+C in the connector’s console window.  The  sample code  calls the Stopping() method on ..."},"26":{y:0,u:"../Content/Tutorial/CompleteSynchronize/Full_Incremental_Sync.htm",l:-1,t:"Full and Incremental Synchronize",i:0.000818349842119718,a:"The synchronize action demonstrated in the  sample code  acts the same way every time it is called: the connector ingests every  file in the repository . This is called a full synchronize, and a connector would typically do this the first time the synchronize action is used. When the synchronize ..."},"27":{y:0,u:"../Content/Tutorial/Datastore/Datastore_Introduction.htm",l:-1,t:"The Datastore",i:0.00121708072439872,a:"The Datastore This section describes how to use the Datastore."},"28":{y:0,u:"../Content/Tutorial/Datastore/Datastore_Overview.htm",l:-1,t:"Introduction",i:0.000497602889741495,a:"The datastore is a feature of ConnectorLib .NET that allows a connector to store structured information in a file.  Each datastore file contains SQL-like tables with defined columns. You can use the features provided by ConnectorLib .NET to create new tables in the datastore, store and retrieve ..."},"29":{y:0,u:"../Content/Tutorial/Datastore/Create_a_DataStoreFile.htm",l:-1,t:"Create a DatastoreFile",i:0.000497602889741495,a:"Create a Datastore File The datastore features are all contained within the  Autonomy.Connector.Datastore  namespace. The samples in this section assume there is  a using  directive for this namespace at the beginning of the file:        using Autonomy.Connector.Datastore; You can access a datastore ..."},"30":{y:0,u:"../Content/Tutorial/Datastore/Create_tables.htm",l:-1,t:"Create Tables",i:0.00113204706303566,a:"The connector described in   A Complete Synchronize Action  always ingests every file, even those that have not changed since the last synchronize. You could improve this connector by implementing  incremental synchronize . To do this, you can create a Datastore table to store the modified date of ..."},"31":{y:0,u:"../Content/Tutorial/Datastore/Insert_Records.htm",l:-1,t:"Insert Records",i:0.000497602889741495,a:"After you have created a datastore table, you can add records to it:        Record record = new Record();\n\n       record[\"Reference\"] = @\"C:\\data\\file1.txt\";\n\n       record.Add(\"LastModified\", new DateTime(\n\t\t2013, 8, 05, 18, 05, 0, DateTimeKind.Utc));\n\n       docs.Insert(record); This example ..."},"32":{y:0,u:"../Content/Tutorial/Datastore/Processing_the_Queue.htm",l:-1,t:"Process the Queue",i:0.000497602889741495,a:"When you insert or update records in a datastore table, the changes are not made immediately. For efficiency reasons they are queued and then committed in batches. To make sure all changes have been committed before you perform a query, you can instruct the datastore to process the queue:        ..."},"33":{y:0,u:"../Content/Tutorial/Datastore/Retrieve_a_Record.htm",l:-1,t:"Retrieve a Record",i:0.00739325872425166,a:"The following example shows how to retrieve (or \"select\") a record by reference:        Record selected = docs.SelectOne(\n\t\tdocs.Column(\"Reference\") == @\"C:\\data\\file1.txt\",\n\t\tnew string[] { \"Reference\", \"LastModified\"}); The first argument specifies the query to perform and selects records where ..."},"34":{y:0,u:"../Content/Tutorial/Datastore/Filters.htm",l:-1,t:"Filters",i:0.00810806385269762,a:"To select records in a table, you must use Filters. For information about selecting records, and for examples of Filters being used, see  Retrieve a Record .  This section describes how to create Filters. Basic Comparisons Normally, you can use operators like \u0027==\u0027, \u0027!=\u0027 and \u0027\u003c\u0027 to perform a single ..."},"35":{y:0,u:"../Content/Tutorial/Datastore/Update_Records.htm",l:-1,t:"Update Records",i:0.000497602889741495,a:"To update records in a table, use the  Update method of the Table class. This method updates all records that match a  filter .  You can update all of the columns for the record, or just some of them. In  Create Tables , a table was introduced that stored a reference and a last modified date.  This ..."},"36":{y:0,u:"../Content/Tutorial/Datastore/Remove_Records.htm",l:-1,t:"Remove Records",i:0.000497602889741495,a:"Remove Records You can remove records with  the Remove method of the Table class.  This method removes all records that match a  filter . For example, to remove all records where the reference is equal to C:\\data\\file1.txt:        docs.Remove(docs.Column(\"Reference\") == @\"C:\\data\\file1.txt\");"},"37":{y:0,u:"../Content/Tutorial/Datastore/Indexes.htm",l:-1,t:"Indexes",i:0.000818349842119718,a:"If your connector frequently uses  filters  based on the value of one column, you can significantly increase the speed of queries by creating an index. To create an index for the Reference column of a table, use the following code:        docs.CreateIndex(new string[] { \"Reference\" }); After the ..."},"38":{y:0,u:"../Content/Tutorial/Datastore/Upgrade_Tables.htm",l:-1,t:"Upgrade Tables",i:0.000497602889741495,a:"You might add a new feature  to your connector that requires a change in the structure of its datastore tables.  If the connector has already been used in a production environment there might be datastore files with the old structure that have been populated with information.  It might be desirable ..."},"39":{y:0,u:"../Content/Tutorial/IncrementalSynchronize/Make_Synchronize_Incremental.htm",l:-1,t:"Make an Incremental Synchronize Action",i:0.00131180642134851,a:"This section shows how the connector introduced in  A Complete Synchronize Action  can be updated to make the synchronize action incremental, by using the datastore functionality described in  The Datastore . An incremental synchronize is more efficient than running a full synchronize every time you ..."},"40":{y:0,u:"../Content/Tutorial/IncrementalSynchronize/Incremental_Synchronize.htm",l:-1,t:"Incremental Synchronize",i:0.000497602889741495,a:"The incremental synchronize implemented by the sample code in  IncrementalSynchronize.sln works by maintaining the following datastore table: The connector adds one row to the table for every file that it finds in the repository.  The full path of the file is used as the  reference.  Ignore ..."},"41":{y:0,u:"../Content/Tutorial/IncrementalSynchronize/Incremental_Synchronize_Example.htm",l:-1,t:"Incremental Synchronize Example",i:0.000497602889741495,a:"This section describes the connector in operation. Cycle 1 To begin with, the datastore table is empty. The “data” directory (the repository from which the sample connector retrieves data) contains three files:        File1.txt\n       File2.txt\n       File3.txt When the synchronize action runs, the ..."},"42":{y:0,u:"../Content/Tutorial/IncrementalSynchronize/Code_Structure.htm",l:-1,t:"Sample Code Structure",i:0.000497602889741495,a:"The sample code in IncrementalSynchronize.sln is split into the following classes: Stop Requests Like the Simple version of the connector (see  A Complete Synchronize Action ), this version must respond to stop requests.  In addition to checking SynchronizeTask.Stopping() this connector makes use of ..."},"43":{y:0,u:"../Content/Tutorial/Actions_Intro.htm",l:-1,t:"Implement Other Actions",i:0.000497602889741495,a:"So far this document has focused on implementing the synchronize fetch action, but a connector can implement other fetch actions in addition to, or instead of, synchronize.  We have already seen how to implement synchronize by overriding the Synchronize method in ConnectorBase. ConnectorBase also ..."},"44":{y:0,u:"../Content/Tutorial/Actions_RetrieveDocuments.htm",l:-1,t:"Retrieve Documents from a Repository",i:0.000920565671937607,a:"The following table lists the fetch actions that retrieve information from a repository. The synchronize action has already been demonstrated in  A Complete Synchronize Action  and  Make an Incremental Synchronize Action . SynchronizeIds, Collect, and View  are all passed one or more  I DocInfo ..."},"45":{y:0,u:"../Content/Tutorial/Actions_UpdateRepository.htm",l:-1,t:"Update Documents in a Repository",i:0.000497602889741495,a:"The following table lists fetch actions that update documents in a repository. Like the Collect fetch action (see  Retrieve Documents from a Repository ), these actions are passed a collection of  I DocInfo objects, each of which contains an identifier.  Like the Collect fetch action,  S uccess or  ..."},"46":{y:0,u:"../Content/Tutorial/Actions_Identifiers.htm",l:-1,t:"Browse a Repository",i:0.000497602889741495,a:"\n            The identifiers fetch action provides information that can be used to browse a repository. It retrieves a list of documents that are present in the repository and generates an identifier for each document. Declare the Types of Identifiers Before implementing the action, you must specify ..."},"47":{y:0,u:"../Content/Tutorial/Actions_RetrieveGroups.htm",l:-1,t:"Retrieve Group Information from a Repository",i:0.000497602889741495,a:"Retrieve Group Information from a Repository The SynchronizeGroups fetch action retrieves group information from a repository. This is discussed in more detail in  Mapped Security ."},"48":{y:0,u:"../Content/Tutorial/Actions_GetUri.htm",l:-1,t:"Retrieve the URI of a Document",i:0.000497602889741495,a:"A connector\u0027s GetUri action takes a document identifier and returns a URI for the document in the repository. The ConnectorBase class defines the entry point for this action:        public void GetUri(IGetUriTask task) To implement the GetUri action, override the GetUri function in your derived ..."},"49":{y:0,u:"../Content/Tutorial/Actions_CustomFetch.htm",l:-1,t:"Implement Custom Fetch Actions",i:0.000497602889741495,a:"You can implement custom fetch actions in a ConnectorLib .NET connector. To implement a custom fetch action, override the CustomFetch method on the ConnectorBase interface. The  CustomFetch method is passed the name of the fetch action that was called in the request. The name is always in upper ..."},"50":{y:0,u:"../Content/Tutorial/Actions_Custom.htm",l:-1,t:"Implement Custom Actions",i:0.000497602889741495,a:"You can implement custom actions in a ConnectorLib .NET connector. To implement a custom action, override the Custom method on the ConnectorBase interface. The  Custom method is passed the name of the action that was called in the request. The name is always in upper case, because action names are ..."},"51":{y:0,u:"../Content/Tutorial/Security/Security_Introduction.htm",l:-1,t:"Mapped Security",i:0.000920565671937607,a:"Documents in a repository can often be viewed only by authenticated users, and different users are allowed to view different documents.  In this case you might want any output from IDOL (for example, search results) to  show only documents that a user has permission to see.  This can be achieved by ..."},"52":{y:0,u:"../Content/Tutorial/Security/AccessControlLists.htm",l:-1,t:"Access Control Lists",i:0.000758430056015434,a:"An Access Control List (ACL) is a string of text that specifies who is allowed to view a document.  Connectors can add an ACL to a document field, usually AUTONOMYMETADATA, for every document that is ingested. This section describes an “NT Style” ACL, which is used in conjunction with the  IDOL ..."},"53":{y:0,u:"../Content/Tutorial/Security/Security_Groups.htm",l:-1,t:"Groups",i:0.00140309617448145,a:"ACLs are often expressed in terms of users and groups. To determine whether a user can access a document, IDOL must know which security groups a user belongs to.  IDOL requests this information from a group server such as OmniGroupServer. The group server can retrieve the group membership ..."},"54":{y:0,u:"../Content/Tutorial/Security/SynchronizeGroups.htm",l:-1,t:"SynchronizeGroups",i:0.000758430056015434,a:"As described in  Groups , it is sometimes necessary for a connector to provide group membership information to a group server. OmniGroupServer might be configured to store group information from a repository with the following settings: ..."},"55":{y:0,u:"../Content/Tutorial/ConnectorLib_Features.htm",l:-1,t:"Logging, Configuration, and Temporary Files",i:0.000497602889741495,a:"Logging, Configuration, and Temporary Files This section describes further useful features of ConnectorLib .NET."},"56":{y:0,u:"../Content/Tutorial/Logging.htm",l:-1,t:"Write Messages to the Log",i:0.000497602889741495,a:" All of the fetch action methods you can override in ConnectorBase are passed a task object with a Log property of type ILog.  This allows you to log messages at a variety of levels:        task.Log.WriteLine(LogLevel.Always,\n\t\t\"This message will always be logged\");\t\n       ..."},"57":{y:0,u:"../Content/Tutorial/ReadConfiguration.htm",l:-1,t:"Read Configuration Parameters",i:0.000497602889741495,a:" All of the fetch action methods you can override in ConnectorBase are passed a task object with a TaskConfig property of type ITaskConfig. You can use this property to read configuration settings from the task\u0027s  configuration.  The task configuration returned by the methods of the TaskConfig ..."},"58":{y:0,u:"../Content/Tutorial/CreateTempFiles.htm",l:-1,t:"Create Temporary Files",i:0.000497602889741495,a:"Your connector might need to create temporary files.  The task objects have a  TempDirectory property   that provides the path of the directory to use for storing temporary files. The Temporary class in the Autonomy.Connector.Utilities namespace provides a convenient method that you can use when ..."},"59":{y:0,u:"../Content/Tutorial/ProgressReporting.htm",l:-1,t:"Progress Reporting",i:0.000497602889741495,a:"The synchronize action is typically used to retrieve all data from a repository. This could take seconds, hours, or even days to complete. You might therefore decide to give the user an indication of how much progress the connector has made and how much work there is left to do. This section ..."},"60":{y:0,u:"../Content/Tutorial/ProgressReporting_Intro.htm",l:-1,t:"Introduction",i:0.000709084280839551,a:"Progress information for a synchronize action can be retrieved using the following HTTP command, sent to the connector\u0027s ACI port: http://host:port/action=QueueInfo\u0026QueueName=Fetch\u0026QueueAction=Progress\u0026Token=token The  QueueInfo  action returns a report of the progress: \u003cautnresponse\u003e\n  ..."},"61":{y:0,u:"../Content/Tutorial/ProgressReporting_Basic.htm",l:-1,t:"Basic Progress",i:0.000709084280839551,a:"ISynchronizeTask has a member called TaskStage that allows you to report progress for the synchronize action.  The following example demonstrates basic progress reporting:    task.TaskStage.Maximum = 20;\n   for (int ii = 0; ii \u003c 20; ++ii)\n   {\n      // Do work\n      ..."},"62":{y:0,u:"../Content/Tutorial/ProgressReporting_Stages.htm",l:-1,t:"Progress with Stages",i:0.000497602889741495,a:"Instead of updating the progress of the task stage directly, you can split it into multiple child stages. This provides more detail in the  progress report . Add Stages Each stage is given a weight and a maximum value:    IStage stage1 = task.TaskStage.AddChild(\"Searching for new Documents\", 1, ..."},"63":{y:0,u:"../Content/Connector_Reference.htm",l:-1,t:"Connector Reference",i:0.000497602889741495,a:"Connector Reference This section describes the actions, configuration parameters, and Lua methods that you can use with any connector developed using the ConnectorLib .NET SDK."},"64":{y:0,u:"../Content/Actions/Actions.htm",l:-1,t:" Actions",i:0.000497602889741495,a:" Actions This section describes the actions that you can use with your connector. Introduction to Actions Connector Actions Fetch Actions"},"65":{y:0,u:"../Content/Actions/_ACI_Actions_Intro.htm",l:-1,t:"Introduction to Actions",i:0.000638590483806866,a:"Actions allow you to query an ACI server  and instruct it to perform a variety of operations. All actions must be sent to the server  Port . The configured authorization roles determine which users can send which actions to the port. See  Authorization Roles Configuration Parameters . The general ..."},"66":{y:0,u:"../Content/Actions/Synchronous_and_Asynchro.htm",l:-1,t:"Synchronous and Asynchronous Actions",i:0.000497602889741495,a:"Some actions are synchronous and others are asynchronous. A connector does not respond to a synchronous action until it has completed the request. The result of the action is in the response to the request. A connector responds to an asynchronous action immediately. The request is added to a queue ..."},"67":{y:0,u:"../Content/Actions/Connector/_CN_Actions_Connector.htm",l:-1,t:"Connector Actions",i:0.000638590483806866,a:"This section describes the actions that are supported by the connector. The connector also supports the Fetch action. For information about using the Fetch action, see  Fetch Actions . The sample HTTP requests in this section are split across multiple lines for readability. When you use these ..."},"68":{y:0,u:"../Content/Actions/General/_ACI_Admin.htm",l:-1,t:"Admin",i:0.000497602889741495,a:"Opens the IDOL Admin interface for the component that you use to call the action. This interface allows you to view data for the component and provides some administrative actions. To use this action, you must have an admin.dat file available for the component. You can configure the location of this ..."},"69":{y:0,u:"../Content/Actions/General/_ACI_BackupServer.htm",l:-1,t:"BackupServer",i:0.00121260118165202,a:"The BackupServer action creates a backup that can be used to restore the server\u0027s state. The backup includes: details of actions that have been queued, are running, and have finished. a copy of the configuration file. information about the files that the connector has retrieved. ConnectorLib .NET ..."},"70":{y:0,u:"../Content/Actions/Connector/_CN_GetUri.htm",l:-1,t:"GetUri",i:0.000497602889741495,a:"\n            This action accepts a document identifier and returns a URI to the document in the repository. /action=GetUri\u0026Identifier=...\n             [\u0026Redirect=true] Type: Synchronous Example http://connector:1234/action=GetUri\u0026Identifier=... Response An example response for this action appears ..."},"71":{y:0,u:"../Content/Actions/Connector/_CN_PauseSchedules.htm",l:-1,t:"PauseSchedules",i:0.00331729260366823,a:"Temporarily stops the connector starting scheduled tasks. Any tasks that are currently running are allowed to finish but the connector will not start tasks that are scheduled to start.  Type: Synchronous Example http://localhost:7002/action=PauseSchedules\u0026Sections=MyTask,AnotherTask Response ..."},"72":{y:0,u:"../Content/Actions/Connector/_CN_PurgeDatastore.htm",l:-1,t:"PurgeDatastore",i:0.000497602889741495,a:"This action instructs the connector to delete the datastore for a fetch task. If any synchronize actions are running, the connector waits for them to finish before deleting the datastore. You might want to delete the datastore for a fetch task if you have modified the task configuration and you need ..."},"73":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo.htm",l:-1,t:"QueueInfo",i:0.0217192337332881,a:"The QueueInfo action provides information about the asynchronous actions that the ACI server has queued, is processing, or has finished. You can use the QueueInfo action to: pause and resume processing the queued actions cancel a queued action change the priority of a queued action retrieve the ..."},"74":{y:0,u:"../Content/Actions/General/_ACI_RestoreServer.htm",l:-1,t:"RestoreServer",i:0.00197908269652988,a:"The RestoreServer action restores a server’s state from a backup created by the BackupServer action. After using the RestoreServer action, you must restart the server. Type: Synchronous Example http://host:port/action=RestoreServer\u0026filename=./backups/filename.zip Response \u003cautnresponse ..."},"75":{y:0,u:"../Content/Actions/Connector/_CN_ResumeSchedules.htm",l:-1,t:"ResumeSchedules",i:0.00331729260366823,a:"Instructs the connector to resume starting scheduled tasks, for task schedules that have been paused by the action   PauseSchedules . Type: Synchronous Example http://localhost:7002/action=ResumeSchedules\u0026Sections=MyTask,AnotherTask Response \u003cautnresponse\u003e\n  \u003caction\u003eRESUMESCHEDULES\u003c/action\u003e\n  ..."},"76":{y:0,u:"../Content/Actions/Connector/_CN_StopFetch.htm",l:-1,t:"StopFetch",i:0.000497602889741495,a:"This action requests all active asynchronous Fetch actions or a particular asynchronous Fetch action to stop. http://host:port/action=StopFetch\n\t\t          [\u0026Token=Fetch_Action_Token] Type: Synchronous Example http://localhost:1234/action=StopFetch Response ..."},"77":{y:0,u:"../Content/Actions/Connector/_CN_TaskList.htm",l:-1,t:"TaskList",i:0.000497602889741495,a:"This action returns a list of the fetch tasks that are configured in the connector\u0027s configuration file, and fetch tasks that the connector ran as a result of receiving a fetch action with a configuration included in the config action parameter. The connector returns (if applicable): The name of the ..."},"78":{y:0,u:"../Content/Actions/Connector/_CN_View.htm",l:-1,t:"View",i:0.000497602889741495,a:"The View action retrieves a single document and returns it. Type: Synchronous Example http://localhost:(Undefined variable: ACIServer.ACIPort)/action=View\u0026Identifier=PGlkIHM9IkRJUjEiIHI9IkM6XEF1dG9ub215XEZpbGVTeXN0ZW1Db25uZWN0b3JDRlNcZGlyMVxmaWxlOC50eHQiLz4 Response The response is the binary ..."},"79":{y:0,u:"../Content/Actions/Fetch/_CN_Action_Fetch.htm",l:-1,t:"Fetch Actions",i:0.00118139283821155,a:"This section describes the fetch actions that are supported by the connector. All of the actions in this section are available through action=Fetch. The sample HTTP requests in this section are split across multiple lines for readability. When using these requests, the whole request must be on one ..."},"80":{y:0,u:"../Content/Actions/Fetch/_CN_Collect.htm",l:-1,t:"Collect",i:0.000497602889741495,a:"\n            This action retrieves documents from a repository and sends the documents to a specified location. You can save the documents to disk or add them to the ingest queue. You must specify the documents that you want to collect by their identifiers.\n        Type: Asynchronous Example ..."},"81":{y:0,u:"../Content/Actions/Fetch/_CN_DeleteRemove.htm",l:-1,t:"Delete/Remove",i:0.000497602889741495,a:"This action deletes documents from a repository by their identifiers. Remove and delete are different names for the same action. Type: Asynchronous Example http://localhost:1234/action=Fetch\u0026FetchAction=Delete\n                                  \u0026Identifiers=...  Response \n             As this is an ..."},"82":{y:0,u:"../Content/Actions/Fetch/_CN_Hold.htm",l:-1,t:"Hold",i:0.000497602889741495,a:"The Hold action places a hold on a document or documents in the repository. When a document has been placed on hold, it cannot be deleted or modified by a regular user. Specify the documents to hold by their identifiers. Type: Asynchronous Example http://localhost:1234/action=Fetch\u0026FetchAction=Hold\n ..."},"83":{y:0,u:"../Content/Actions/Fetch/Insert.htm",l:-1,t:"Insert",i:0.000497602889741495,a:"Inserts a document or documents into the data repository. Type: Asynchronous Example \n            This example shows how to use a File System Connector to insert a file with the reference C:\\Autonomy\\FileSystemConnectorCFS\\dir1\\newfile.txt and the content This is my file into a file system. \n        ..."},"84":{y:0,u:"../Content/Actions/Fetch/_CN_ReleaseHold.htm",l:-1,t:"ReleaseHold",i:0.000497602889741495,a:"The ReleaseHold action releases a document that has been placed on hold.\n         Documents are specified by their identifier.\n        Type: Asynchronous Example\n         http://localhost:1234/action=Fetch\u0026FetchAction=ReleaseHold\n                                  ..."},"85":{y:0,u:"../Content/Actions/Fetch/_CN_Stub.htm",l:-1,t:"Stub",i:0.000497602889741495,a:"\n            This action inserts a stub, a link to a document in another repository. An application might use a connector to insert a stub when a document is moved to another repository or is deleted. The stub can point to the new location, or in the case where the document has been deleted, explain ..."},"86":{y:0,u:"../Content/Actions/Fetch/_CN_Synchronize.htm",l:-1,t:"Synchronize",i:0.000497602889741495,a:"This action searches a repository for new, updated, and deleted documents, and sends the updates to an ingestion server. Type: Asynchronous Example http://host:port/action=Fetch\u0026FetchAction=Synchronize Response A sample response appears below. In this example, two tasks were performed as part of the ..."},"87":{y:0,u:"../Content/Actions/Fetch/_CN_SynchronizeGroups.htm",l:-1,t:"SynchronizeGroups",i:0.000497602889741495,a:"This action searches a repository for group updates and sends these updates to OmniGroupServer. Type: Asynchronous Example http://host:port/action=Fetch\u0026FetchAction=SynchronizeGroups Response A sample response appears below. In this example, two tasks were performed as part of the synchronize groups ..."},"88":{y:0,u:"../Content/Actions/Fetch/_CN_Update.htm",l:-1,t:"Update",i:0.000497602889741495,a:"The Update action updates the metadata of documents in a repository.\nDocuments are specified by their identifier.           /action=fetch\u0026fetchaction=Update\n\t\t      [\u0026config=\u003cBase64_Config\u003e]\n\t\t       \u0026identifiersXML=\u003cIdentifiers_XML\u003e\n\t\t      [\u0026\u003cOverride_Config_Parameters\u003e]\n Type: Asynchronous ..."},"89":{y:0,u:"../Content/Configuration/ConfigParameters.htm",l:-1,t:"Configuration Parameters",i:0.000497602889741495,a:"This section describes the configuration parameters that you can use with your connector. Introduction to Configuration .NET Parameters Actions Configuration Parameters Connector Configuration Parameters Distributed Connector Configuration Parameters Document Tracking Configuration Parameters ..."},"90":{y:0,u:"../Content/Configuration/_ACI_Config_Intro.htm",l:-1,t:"Introduction to Configuration",i:0.00052248305340009,a:"Configuration parameters are set in the  configuration file. When setting configuration parameter values, you must use UTF-8. This section describes how to enter parameter values in the configuration file. Enter Boolean Values The following settings for Boolean parameters are interchangeable: TRUE = ..."},"91":{y:0,u:"../Content/Configuration/DotNet/_CN_params_dotnet.htm",l:-1,t:".NET Parameters",i:0.00052248305340009,a:".NET Parameters This section describes additional configuration parameters for connectors that use the .NET Framework."},"92":{y:0,u:"../Content/Configuration/DotNet/_CN_DotNetConnectorClass.htm",l:-1,t:"DotNetConnectorClass",i:0.000497602889741495,a:"DotNetConnectorClass The full class name containing the connector implementation."},"93":{y:0,u:"../Content/Configuration/DotNet/_CN_DotNetConnectorLibrary.htm",l:-1,t:"DotNetConnectorLibrary",i:0.000497602889741495,a:"DotNetConnectorLibrary The path and file name of the connector library."},"94":{y:0,u:"../Content/Configuration/Actions/_ACI_params_actions.htm",l:-1,t:"Actions Configuration Parameters",i:0.00052248305340009,a:"The parameters in the [Actions] section control how the server handles incoming ACI requests, and are used to set up event handlers. AsyncStoreLibraryDirectory AsyncStoreLibraryName ConnectionString DatastoreSharingGroupName DeleteProcessingRequestsWhenServerStarts ..."},"95":{y:0,u:"../Content/Configuration/Actions/_ACI_AsyncStoreLibraryDirectory.htm",l:-1,t:"AsyncStoreLibraryDirectory",i:0.00479442636517749,a:" To store asynchronous action queues in a database, rather than in an internal datastore file, set the parameters AsyncStoreLibraryDirectory, AsyncStoreLibraryName, and ConnectionString. If you use the same database to store action queues for more than one type of component, you must also set ..."},"96":{y:0,u:"../Content/Configuration/Actions/_ACI_AsyncStoreLibraryName.htm",l:-1,t:"AsyncStoreLibraryName",i:0.00479442636517749,a:" To store asynchronous action queues in a database, rather than in an internal datastore file, set the parameters AsyncStoreLibraryDirectory, AsyncStoreLibraryName, and ConnectionString. If you use the same database to store action queues for more than one type of component, you must also set ..."},"97":{y:0,u:"../Content/Configuration/Actions/_ACI_ConnectionString.htm",l:-1,t:"ConnectionString",i:0.00479442636517749,a:" To store asynchronous action queues in a database, rather than in an internal datastore file, set the parameters AsyncStoreLibraryDirectory, AsyncStoreLibraryName, and ConnectionString. If you use the same database to store action queues for more than one type of component, you must also set ..."},"98":{y:0,u:"../Content/Configuration/Actions/_ACI_DatastoreSharingGroupName.htm",l:-1,t:"DatastoreSharingGroupName",i:0.00459399971590538,a:"To store asynchronous action queues in a database, rather than in an internal datastore file, set the parameters AsyncStoreLibraryDirectory, AsyncStoreLibraryName, and ConnectionString. To use the same database to store action queues for more than one type of IDOL component, you must also set ..."},"99":{y:0,u:"../Content/Configuration/Actions/_ACI_DeleteProcessingRequestsWhenServerStarts.htm",l:-1,t:"DeleteProcessingRequestsWhenServerStarts",i:0.00345827706324382,a:"Specifies whether to remove requests that have a status of processing from the action queue when the server starts. In most cases OpenText recommends that you use the default value, so that when the server starts it continues to process unfinished requests. However, if a request causes the server to ..."},"100":{y:0,u:"../Content/Configuration/Actions/_ACI_DeleteQueuedRequestsWhenServerStarts.htm",l:-1,t:"DeleteQueuedRequestsWhenServerStarts",i:0.00345827706324382,a:"Specifies whether to remove requests that have a status of queued from the action queue when the server starts. The action queue can contain queued requests if the server was stopped before it could process all of the requests in the queue. In most cases OpenText recommends that you use the default ..."},"101":{y:0,u:"../Content/Configuration/Actions/_ACI_InMemoryDatastoreBackupIntervalMins.htm",l:-1,t:"InMemoryDatastoreBackupIntervalMins",i:0.00379610987085701,a:"The time interval (in minutes) after which action queues stored in memory are written to disk. This parameter applies only when  UseInMemoryDatastore  is TRUE. Writing the queues to disk can reduce the number of actions that would be lost if ConnectorLib .NET stops unexpectedly, but configuring ..."},"102":{y:0,u:"../Content/Configuration/Actions/_ACI_LibraryName.htm",l:-1,t:"LibraryName",i:0.00482369896713379,a:"The LibraryName parameter specifies the name of the library to use as the event handler. Specifying the .dll or .so extension is optional.  To use the internal text file handler, set this parameter to TextFileHandler, and set the FilePath parameter. To run a Lua script, set this parameter to ..."},"103":{y:0,u:"../Content/Configuration/Actions/_ACI_MaxDatastoreConnections.htm",l:-1,t:"MaxDatastoreConnections",i:0.00051875102983662,a:" The maximum number of connections to open to the database that stores asynchronous action queues. In most cases the default value of one connection is sufficient. Increasing the number of connections allows more threads to communicate with the database concurrently. This can improve performance but ..."},"104":{y:0,u:"../Content/Configuration/Actions/_ACI_MaxFinishedSize.htm",l:-1,t:"MaxFinishedSize",i:0.00345827706324382,a:"The MaxFinishedSize parameter specifies the maximum number of Finished + Error tasks to store. When the MaxFinishedSize is reached, the oldest Finished or Error action is disposed of and so is no longer accessible through the QueueInfo action. Queued, Processing, Finished, and Error are the action ..."},"105":{y:0,u:"../Content/Configuration/Actions/_ACI_MaximumThreads.htm",l:-1,t:"MaximumThreads",i:0.000941713812032732,a:"The MaximumThreads parameter specifies the maximum number of asynchronous ACI actions to process simultaneously. If you set this parameter only in the [Actions] section of the configuration file, the server simultaneously runs the specified number of actions from each asynchronous queue. You can ..."},"106":{y:0,u:"../Content/Configuration/Actions/_ACI_MaxQueueSize.htm",l:-1,t:"MaxQueueSize",i:0.00345827706324382,a:"The MaxQueueSize parameter specifies the maximum number of asynchronous actions that are queued by the server. When the maximum number is reached, no further actions are accepted until the queue has diminished. If you set this parameter only in the [Actions] section of the configuration file, the ..."},"107":{y:0,u:"../Content/Configuration/Actions/_ACI_OnError.htm",l:-1,t:"OnError",i:0.00319461845773757,a:"The OnError parameter specifies the name of a handler for the error event of an asynchronous action. The OnError event is called if an asynchronous action fails and cannot continue. The name that you specify must represent a section in the configuration file that contains the  LibraryName  parameter ..."},"108":{y:0,u:"../Content/Configuration/Actions/_ACI_OnFinish.htm",l:-1,t:"OnFinish",i:0.0028770225729854,a:"The OnFinish parameter specifies the name of a handler for the finish event of an asynchronous action. The name that you specify must represent a section in the configuration file that contains the settings for the event handler. For example: [ActionName]\nOnFinish=MyHandler\n\n[MyHandler]\n...\n"},"109":{y:0,u:"../Content/Configuration/Actions/_ACI_OnQueueEvent.htm",l:-1,t:"OnQueueEvent",i:0.00162615321460639,a:"ConnectorLib .NET generates an event when an asynchronous action queue becomes full, becomes empty, or the queue size passes certain thresholds. The OnQueueEvent parameter specifies the name of the handler to use to handle these events. A QueueFull event occurs when the action queue becomes full. A ..."},"110":{y:0,u:"../Content/Configuration/Actions/_ACI_OnStart.htm",l:-1,t:"OnStart",i:0.0028770225729854,a:"OnStart The OnStart parameter specifies the name of a handler for the start event of an asynchronous action. The name that you specify must represent a section in the configuration file that contains the settings for the event handler. For example: [ActionName]\nOnStart=MyHandler\n\n[MyHandler]\n...\n"},"111":{y:0,u:"../Content/Configuration/Actions/_ACI_Path.htm",l:-1,t:"Path",i:0.00051875102983662,a:"Path The directory in which to store information about asynchronous ACI actions. "},"112":{y:0,u:"../Content/Configuration/Actions/_ACI_QueueEmptyingThreshold.htm",l:-1,t:"QueueEmptyingThreshold",i:0.00130282418311426,a:"ConnectorLib .NET generates an event when an asynchronous action queue becomes full, becomes empty, or the queue size passes certain thresholds. This parameter specifies the threshold at which a QueueEmptying event is triggered. When the number of actions in a queue falls below this proportion of ..."},"113":{y:0,u:"../Content/Configuration/Actions/_ACI_QueueFillingThreshold.htm",l:-1,t:"QueueFillingThreshold",i:0.00130282418311426,a:"ConnectorLib .NET generates an event when an asynchronous action queue becomes full, becomes empty, or the queue size passes certain thresholds. This parameter specifies the threshold at which a QueueFilling event is triggered. When the number of actions in a queue exceeds this proportion of the ..."},"114":{y:0,u:"../Content/Configuration/Actions/_ACI_UseInMemoryDatastore.htm",l:-1,t:"UseInMemoryDatastore",i:0.00385532576398242,a:"A Boolean value that specifies whether to keep the queues for asynchronous actions in memory. Storing action queues in memory can improve performance but means that the queues (including queued actions and the results of finished actions) are lost if ConnectorLib .NET stops unexpectedly, for example ..."},"115":{y:0,u:"../Content/Configuration/Actions/_ACI_UseStringentDatastore.htm",l:-1,t:"UseStringentDatastore",i:0.00051875102983662,a:"The datastore that holds the action queues for ConnectorLib .NET is resistant to corruption when a system failure (such as a loss of power) occurs. To increase the speed at which the datastore responds to queries from ConnectorLib .NET, you can set UseStringentDatastore=False, however the datastore ..."},"116":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_HTTP_Event_Handler_Config.htm",l:-1,t:"HTTP Event Handler Configuration",i:0.000497602889741495,a:"HTTP Event Handler Configuration The parameters in this section specify settings for the HTTP event handler. These settings are used if LibraryName=HttpHandler."},"117":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_BasicPassword.htm",l:-1,t:"BasicPassword",i:0.00331729260366823,a:"BasicPassword The BasicPassword parameter specifies the password to use to access the URL where event data is sent (when using basic authentication). This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"118":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_BasicUser.htm",l:-1,t:"BasicUser",i:0.00331729260366823,a:"BasicUser The BasicUser parameter specifies the user name to use to access the URL where event data is sent (when using basic authentication). This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"119":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_NTLMPassword.htm",l:-1,t:"NTLMPassword",i:0.00331729260366823,a:"NTLMPassword The NTLMPassword parameter specifies the password to use to access the URL where event data is sent (when using NTLM or NTLMv2 authentication). This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"120":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_NTLMUser.htm",l:-1,t:"NTLMUser",i:0.00331729260366823,a:"NTLMUser The NTLMUser parameter specifies the user name to use to access the URL where event data is sent (when using NTLM or NTLMv2 authentication). This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"121":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_ProxyHost.htm",l:-1,t:"ProxyHost",i:0.00144120130174202,a:"ProxyHost The ProxyHost parameter specifies the host name or IP address of a proxy server to use to send event data. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"122":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_ProxyPassword.htm",l:-1,t:"ProxyPassword",i:0.00519338390559443,a:"ProxyPassword The ProxyPassword parameter specifies a password for the proxy server. You can set this parameter if you need to send event data through a proxy server. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"123":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_ProxyPort.htm",l:-1,t:"ProxyPort",i:0.00111011429594791,a:"ProxyPort The ProxyPort parameter specifies the port of a proxy server to use to send event data. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"124":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_ProxyUser.htm",l:-1,t:"ProxyUsername",i:0.00552447091138854,a:"ProxyUsername The ProxyUsername parameter specifies a user name for the proxy server. You can set this parameter if you need to send event data through a proxy server. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"125":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_Retries.htm",l:-1,t:"Retries",i:0.00331729260366823,a:"Retries The Retries parameter specifies the number of times that the connector should attempt to connect to the URL where event data is sent, if the initial connection fails. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"126":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_RetryInterval.htm",l:-1,t:"RetryInterval",i:0.00331729260366823,a:"RetryInterval The RetryInterval parameter specifies the amount of time (in seconds) between attempts to connect to the URL. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"127":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_SSLConfig.htm",l:-1,t:"SSLConfig",i:0.000497602889741495,a:"SSLConfig The SSLConfig parameter specifies the name of a section in the configuration file that contains SSL settings for communication with the URL. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},});