define({"402":{y:0,u:"../Content/Lua/_LUA_Lua_Scripts.htm",l:-1,t:"Lua Functions and Methods Reference",i:0.000722797001409724,a:"Lua Functions and Methods Reference This section describes the functions and methods that you can use in your Lua scripts. IDOL Community Component includes Lua version 5.3.0. Any Lua modules that you use must be compatible with this version."},"403":{y:0,u:"../Content/Lua/General/_LUA_General_Methods.htm",l:-1,t:"General Functions",i:0.000260326105696442,a:"General Functions"},"404":{y:0,u:"../Content/Lua/General/_LUA_abs_path.htm",l:-1,t:"abs_path",i:0.00026450114817451,a:"abs_path The abs_path method returns the supplied path as an absolute path. Syntax abs_path( path ) Arguments Returns (String). A string containing the supplied path as an absolute path."},"405":{y:0,u:"../Content/Lua/General/_LUA_base64_decode.htm",l:-1,t:"base64_decode",i:0.00026450114817451,a:"base64_decode The base64_decode method decodes a base64-encoded  string. Syntax base64_decode( input ) Arguments Returns (String). The decoded string. If the input is not a valid base64-encoded string, the function returns nil."},"406":{y:0,u:"../Content/Lua/General/_LUA_base64_encode.htm",l:-1,t:"base64_encode",i:0.00026450114817451,a:"base64_encode The base64_encode method base64-encodes a string. Syntax base64_encode( input ) Arguments Returns (String). A base64-encoded string."},"407":{y:0,u:"../Content/Lua/General/_LUA_convert_date_time.htm",l:-1,t:"convert_date_time",i:0.00026450114817451,a:"The convert_date_time method converts date and time formats using standard IDOL formats. All date and time input is treated as local time unless it contains explicit time zone information. The InputFormatCSV and OutputFormat arguments specify date and time formats, and accept the following values: ..."},"408":{y:0,u:"../Content/Lua/General/_LUA_convert_encoding.htm",l:-1,t:"convert_encoding",i:0.000489327186807005,a:"convert_encoding The convert_encoding method converts the encoding of a string from one character encoding to another. Syntax convert_encoding( input, encodingTo, encodingTables [, encodingFrom]) Arguments Returns (String). A string, using the specified character encoding."},"409":{y:0,u:"../Content/Lua/General/_LUA_copy_file.htm",l:-1,t:"copy_file",i:0.00026450114817451,a:"copy_file The copy_file method copies a file. Syntax copy_file( src, dest [, overwrite] ) Arguments Returns (Boolean). A Boolean, true to indicate success or false for failure."},"410":{y:0,u:"../Content/Lua/General/_LUA_create_path.htm",l:-1,t:"create_path",i:0.00026450114817451,a:"create_path The create_path method creates the specified directory tree. Syntax create_path( path ) Arguments"},"411":{y:0,u:"../Content/Lua/General/_LUA_create_uuid.htm",l:-1,t:"create_uuid",i:0.00026450114817451,a:"create_uuid The create_uuid method creates a universally unique identifier. Syntax create_uuid() Returns (String). A string containing the universally unique identifier."},"412":{y:0,u:"../Content/Lua/General/_LUA_delete_file.htm",l:-1,t:"delete_file",i:0.00026450114817451,a:"delete_file The delete_file method deletes a file. Syntax delete_file( path ) Arguments Returns (Boolean). A boolean, true to indicate success or false for failure."},"413":{y:0,u:"../Content/Lua/General/_LUA_delete_path.htm",l:-1,t:"delete_path",i:0.00026450114817451,a:"delete_path The delete_path function deletes the specified directory, but only if it is empty. Syntax delete_path( path ) Arguments Returns Nothing. Example delete_path( \"C:\\MyFolder\\AnotherFolder\\\" )"},"414":{y:0,u:"../Content/Lua/General/_LUA_doc_tracking.htm",l:-1,t:"doc_tracking",i:0.00026450114817451,a:"The doc_tracking function raises a document tracking event for a document. Syntax doc_tracking( document , eventName [, eventMetadata] [, reference] ) Arguments Returns (Boolean). A Boolean that indicates whether the event was raised successfully. Example local ..."},"415":{y:0,u:"../Content/Lua/General/_LUA_encrypt.htm",l:-1,t:"encrypt",i:0.000489327186807005,a:"encrypt The encrypt method encrypts a string and returns the encrypted string. It uses the same encryption method as ACL encryption. Syntax encrypt( content ) Arguments Returns (String). The encrypted string."},"416":{y:0,u:"../Content/Lua/General/_LUA_encrypt_security_field.htm",l:-1,t:"encrypt_security_field",i:0.00026450114817451,a:"The encrypt_security_field method returns the encrypted form of the supplied ACL string. This function is similar to the  encrypt  function, but is intended for use with Access Control Lists (ACLs). The function encrypts user and group names, but not delimiters such as :U:,:NU:, and the commas in ..."},"417":{y:0,u:"../Content/Lua/General/_LUA_extract_date.htm",l:-1,t:"extract_date",i:0.00026450114817451,a:"The extract_date function searches a string for a date and returns the date. This function uses standard IDOL date formats.  All date and time input is treated as local time unless it contains explicit time zone information. The following table describes the standard IDOL date formats: The following ..."},"418":{y:0,u:"../Content/Lua/General/_LUA_file_setdates.htm",l:-1,t:"file_setdates",i:0.00026450114817451,a:"The file_setdates method sets the metadata for the file specified by path. If the format argument is not specified, the dates must be specified in seconds since the epoch (1st January 1970). Syntax file_setdates( path, created, modified, accessed [, format] ) Arguments Returns (Boolean). A Boolean ..."},"419":{y:0,u:"../Content/Lua/General/_LUA_get_config.htm",l:-1,t:"get_config",i:0.000787729527009727,a:"The get_config function loads a configuration file. Configuration files are cached after the first call to get_config, to avoid unnecessary disk I/O in the likely event that the same configuration is accessed frequently by subsequent invocations of the Lua script. One cache is maintained per Lua ..."},"420":{y:0,u:"../Content/Lua/General/_LUA_get_log.htm",l:-1,t:"get_log",i:0.00026450114817451,a:"This version of the get_log function is deprecated in IDOL Community Component 11.4.0 and later. This version of the function is still available for existing implementations, but it might be incompatible with new functionality. This version of the function might be removed in future. Micro Focus ..."},"421":{y:0,u:"../Content/Lua/General/_LUA_get_log2.htm",l:-1,t:"get_log",i:0.00134809768991192,a:"get_log The get_log method returns a  LuaLog  object that provides the capability to write messages to a specified log type. Syntax get_log( log_type ) Arguments Returns (LuaLog). A  LuaLog  object. Example local log = get_log(\"application\")\nlog:write_line(log_level_normal(), \"doing something...\")"},"422":{y:0,u:"../Content/Lua/General/_LUA_get_log_service.htm",l:-1,t:"get_log_service",i:0.000379829902791907,a:"The get_log_service function obtains a  LuaLogService  object, from which you can obtain a  LuaLog  object that you can use to write messages to a log file. To obtain a LuaLog object for writing to a standard log stream, call the function without any arguments or use the function  get_log  instead. ..."},"423":{y:0,u:"../Content/Lua/General/_LUA_getcwd.htm",l:-1,t:"getcwd",i:0.00026450114817451,a:"getcwd The getcwd method returns the current working directory of the application. Syntax getcwd() Returns (String). Returns a string containing the absolute path of the current working directory."},"424":{y:0,u:"../Content/Lua/General/_LUA_gobble_whitespace.htm",l:-1,t:"gobble_whitespace",i:0.00026450114817451,a:"gobble_whitespace The gobble_whitespace method reduces multiple adjacent white spaces (tabs, carriage returns, spaces, and so on) in the specified string to a single space. Syntax gobble_whitespace( input ) Arguments Returns (String). A string without adjacent white spaces."},"425":{y:0,u:"../Content/Lua/General/_LUA_hash_file.htm",l:-1,t:"hash_file",i:0.00026450114817451,a:"hash_file The hash_file method hashes the contents of the specified file using the SHA1 or MD5 algorithm. Syntax hash_file( FileName, Algorithm ) Arguments Returns (String). A hash of the file contents."},"426":{y:0,u:"../Content/Lua/General/_LUA_hash_string.htm",l:-1,t:"hash_string",i:0.00026450114817451,a:"hash_string The hash_string method hashes the specified string using the SHA1 or MD5 algorithm. Syntax hash_string( StringToHash, Algorithm ) Arguments Returns (String). The hashed input string."},"427":{y:0,u:"../Content/Lua/General/_LUA_is_dir.htm",l:-1,t:"is_dir",i:0.00026450114817451,a:"is_dir The is_dir method checks if the supplied path is a directory. Syntax is_dir( path ) Arguments Returns (Boolean). Returns true if the supplied path is a directory, false otherwise."},"428":{y:0,u:"../Content/Lua/General/_LUA_log.htm",l:-1,t:"log",i:0.00026450114817451,a:"log The log method appends log messages to the specified file. Syntax log( file, message ) Arguments"},"429":{y:0,u:"../Content/Lua/General/_LUA_move_file.htm",l:-1,t:"move_file",i:0.00026450114817451,a:"move_file The move_file method moves a file. Syntax move_file( src, dest [, overwrite] ) Arguments Returns (Boolean). Returns true to indicate success, false otherwise."},"430":{y:0,u:"../Content/Lua/General/_LUA_parse_csv.htm",l:-1,t:"parse_csv",i:0.00026450114817451,a:"The parse_csv method parses a string of comma-separated values into individual strings. The method understands quoted values (such that parsing \u0027foot, \"leg, torso\", elbow\u0027 produces three values) and ignores white space around delimiters. Syntax parse_csv( input [, delimiter ] ) Arguments Returns ..."},"431":{y:0,u:"../Content/Lua/General/_LUA_parse_document_csv.htm",l:-1,t:"parse_document_csv",i:0.00026450114817451,a:"The parse_document_csv function parses a CSV file into documents and calls a function on each document. This function can handle CSV files with or without a header row, but if a header row is not present you must: set the named parameter use_header_row to false. specify the document field names to ..."},"432":{y:0,u:"../Content/Lua/General/_LUA_parse_document_idx.htm",l:-1,t:"parse_document_idx",i:0.000339443161052008,a:"Parses an IDX file into documents and calls a function on each document. Syntax parse_document_idx( filename, handler ) Arguments Example The following example uses the parse_document_idx function to parse an IDX file, and calls the function appendDocumentReference on each document. \nlocal ..."},"433":{y:0,u:"../Content/Lua/General/_LUA_parse_document_idx2.htm",l:-1,t:"parse_document_idx",i:0.00026450114817451,a:"Parses an IDX file, or a string of IDX data, and returns a  LuaDocument . You can use this function if the file or string contains a single document. If you have a file or string that contains multiple documents, use one of the following functions instead: parse_document_idx(filename, handler) ..."},"434":{y:0,u:"../Content/Lua/General/_LUA_parse_document_idx3.htm",l:-1,t:"parse_document_idx",i:0.000339443161052008,a:"parse_document_idx Parses an IDX file, or a string of IDX data, into documents and calls a function on each document. Syntax parse_document_idx( input, isFile, handler ) Arguments Returns Nothing."},"435":{y:0,u:"../Content/Lua/General/_LUA_parse_document_xml.htm",l:-1,t:"parse_document_xml",i:0.000339443161052008,a:"Parses an XML file into documents and calls a function on each document. Syntax parse_document_xml( filename, handler [, params ] ) Arguments Named Parameters Example The following example parses an XML file named data.xml, and calls the function printReference on each document. Two values have been ..."},"436":{y:0,u:"../Content/Lua/General/_LUA_parse_document_xml2.htm",l:-1,t:"parse_document_xml",i:0.00026450114817451,a:"Parses an XML file, or a string of XML data, and returns a LuaDocument. You can use this function if the file or string contains a single document. If you have a file or string that contains multiple documents, use one of the following functions instead: parse_document_xml(filename, handler [, ..."},"437":{y:0,u:"../Content/Lua/General/_LUA_parse_document_xml3.htm",l:-1,t:"parse_document_xml",i:0.000339443161052008,a:"parse_document_xml Parses an XML file, or a string of XML data, into documents and calls a function on each document. Syntax parse_document_xml( input, isFile, handler [, params ] ) Arguments Named Parameters Returns Nothing."},"438":{y:0,u:"../Content/Lua/General/_LUA_parse_json.htm",l:-1,t:"parse_json",i:0.000493642236762008,a:"The parse_json function parses a string of JSON and returns a JSON value. Syntax parse_json( json ) Arguments Returns ( LuaJsonValue ). A LuaJsonValue containing the JSON data. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n\nlocal myJsonValue = ..."},"439":{y:0,u:"../Content/Lua/General/_LUA_parse_json_array.htm",l:-1,t:"parse_json_array",i:0.000404366495351319,a:"The parse_json_array function parses a string and returns a JSON array. Syntax parse_json_array( json ) Arguments Returns ( LuaJsonArray ). A LuaJsonArray containing the JSON data. See Also If you can\u0027t be sure whether the input data is a JSON array, you can use the function  parse_json  to parse ..."},"440":{y:0,u:"../Content/Lua/General/_LUA_parse_json_object.htm",l:-1,t:"parse_json_object",i:0.000404366495351319,a:"The parse_json_object function parses a string and returns a JSON object. Syntax parse_json_object( json ) Arguments Returns ( LuaJsonObject ). A LuaJsonObject containing the JSON data. See Also If you can\u0027t be sure whether the input data is a JSON object, you can use the function  parse_json  to ..."},"441":{y:0,u:"../Content/Lua/General/_LUA_parse_xml.htm",l:-1,t:"parse_xml",i:0.00026450114817451,a:"The parse_xml method parses an XML string to a LuaXmlDocument. The following character encodings are supported. If the XML uses a different character encoding, you can use the function  convert_encoding  to convert the encoding before parsing the XML. UTF-8 UTF-16 ISO-Latin-1 (ISO-8859-1) ASCII ..."},"442":{y:0,u:"../Content/Lua/General/_LUA_regex_match.htm",l:-1,t:"regex_match",i:0.00026450114817451,a:"The regex_match method performs a regular expression match on a string. Syntax regex_match( input, regex [, case] ) Arguments Returns One or more strings, or nil. If the string matches the regular expression, and the regular expression has no sub-matches, the full string is returned. If the string ..."},"443":{y:0,u:"../Content/Lua/General/_LUA_regex_replace_all.htm",l:-1,t:"regex_replace_all",i:0.00026450114817451,a:"The regex_replace_all method searches a string for matches to a regular expression, and replaces the matches according to the value specified by the replacement argument. Syntax regex_replace_all( input, regex, replacement ) Arguments Returns (String). The modified string. Examples ..."},"444":{y:0,u:"../Content/Lua/General/_LUA_regex_search.htm",l:-1,t:"regex_search",i:0.00026450114817451,a:"regex_search The regex_search method performs a regular expression search on a string. This method returns a LuaRegexMatch object, rather than strings. Syntax regex_search ( input, regex [, case]) Arguments Returns (LuaRegexMatch)."},"445":{y:0,u:"../Content/Lua/General/_LUA_script_path.htm",l:-1,t:"script_path",i:0.00026450114817451,a:"The script_path function returns the path and file name of the script that is running. Syntax script_path() Returns (String, String) Returns the path of the folder that contains the script and the file name of the script, as separate strings. Example local script_directory, script_filename = ..."},"446":{y:0,u:"../Content/Lua/General/_LUA_send_aci_action.htm",l:-1,t:"send_aci_action",i:0.00257286883008078,a:"The send_aci_action method sends a query to an ACI server. This method takes the action parameters as a table instead of the full action as a string, as with send_aci_command. This avoids issues with parameter values containing an ampersand (\u0026). Syntax send_aci_action( host, port, action [, ..."},"447":{y:0,u:"../Content/Lua/General/_LUA_send_aci_command.htm",l:-1,t:"send_aci_command",i:0.00245261086082096,a:"The send_aci_command method sends a query to an ACI server. Syntax send_aci_command( host, port, query [, timeout] [, retries] [, sslParameters] ) Arguments Returns (String). Returns the XML response as a string. If required, you can call parse_xml on the string to return a LuaXmlDocument. If the ..."},"448":{y:0,u:"../Content/Lua/General/_LUA_send_and_wait_for_async_aci_action.htm",l:-1,t:"send_and_wait_for_async_aci_action",i:0.00026450114817451,a:"The send_and_wait_for_async_aci_action method sends a query to an ACI server. The method does not return until the action has completed. You might use this method when you want to use an asynchronous action. The send_aci_action method returns as soon as it receives a response, which for an ..."},"449":{y:0,u:"../Content/Lua/General/_LUA_sleep.htm",l:-1,t:"sleep",i:0.00026450114817451,a:"sleep The sleep method pauses the thread. Syntax sleep( milliseconds ) Arguments"},"450":{y:0,u:"../Content/Lua/General/_LUA_unzip_file.htm",l:-1,t:"unzip_file",i:0.00026450114817451,a:"unzip_file The unzip_file method extracts the contents of a zip file. Syntax unzip_file( path, dest ) Arguments Returns (Boolean). Returns a Boolean indicating success or failure."},"451":{y:0,u:"../Content/Lua/General/_LUA_url_escape.htm",l:-1,t:"url_escape",i:0.00026450114817451,a:"url_escape The url_escape method percent-encodes a string. Syntax url_escape( input ) Arguments Returns (String). The percent-encoded string."},"452":{y:0,u:"../Content/Lua/General/_LUA_url_unescape.htm",l:-1,t:"url_unescape",i:0.00026450114817451,a:"url_unescape The url_unescape method replaces URL escaped characters and returns a standard string. Syntax url_unescape( input ) Arguments Returns (String). The modified string."},"453":{y:0,u:"../Content/Lua/General/_LUA_xml_encode.htm",l:-1,t:"xml_encode",i:0.00026450114817451,a:"xml_encode The xml_encode method takes a string and encodes it using XML escaping. Syntax xml_encode ( content ) Arguments Returns (String)."},"454":{y:0,u:"../Content/Lua/General/_LUA_zip_file.htm",l:-1,t:"zip_file",i:0.00026450114817451,a:"The zip_file method zips the supplied path (file or directory). It overwrites the output file only if you set the optional overwrite argument to true. Syntax zip_file( path [, overwrite] ) Arguments Returns (Boolean). Returns a Boolean indicating success or failure. On success writes a file called ..."},"455":{y:0,u:"../Content/Lua/LuaConfig/_LUA_LuaConfig_Methods.htm",l:-1,t:"LuaConfig Methods",i:0.000260326105696442,a:"A LuaConfig object provides access to configuration information. You can retrieve a LuaConfig for a given configuration file using the get_config function. If you have a LuaConfig object called config you can call its methods using the \u0027:\u0027 operator. For example: config:getValue(sectionName, ..."},"456":{y:0,u:"../Content/Lua/LuaConfig/_LUA_getEncryptedValue.htm",l:-1,t:"getEncryptedValue",i:0.000315645418530843,a:"getEncryptedValue The getEncryptedValue method returns the unencrypted value from the configuration file of an encrypted value. Syntax getEncryptedValue( section, parameter ) Arguments Returns (String). The unencrypted value."},"457":{y:0,u:"../Content/Lua/LuaConfig/_LUA_getValue.htm",l:-1,t:"getValue",i:0.000315645418530843,a:"The getValue method returns the value of the configuration parameter key in a given section. If the key does not exist in the section, then it returns the default value. Syntax getValue( section, key [, default] ) Arguments Returns A string, boolean, or integer containing the value read from the ..."},"458":{y:0,u:"../Content/Lua/LuaConfig/_LUA_getValues.htm",l:-1,t:"getValues",i:0.000315645418530843,a:"The getValues method returns multiple values for a parameter (for example, a comma-separated list or numbered list like keyN). Syntax getValues( section, parameter ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call ..."},"459":{y:0,u:"../Content/Lua/LuaConfig/_LUA_LuaConfig_new.htm",l:-1,t:"LuaConfig:new",i:0.000567889150487767,a:"LuaConfig:new The constructor for a LuaConfig object (creates a new LuaConfig object). Syntax LuaConfig:new( config_buffer ) Arguments Returns (LuaConfig). The new LuaConfig object. Example local config_buffer = \"[default]\\nparameter=value\"\nlocal config = LuaConfig:new(config_buffer)"},"460":{y:0,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_Methods.htm",l:-1,t:"LuaDocument Methods",i:0.000410210131451438,a:"This section describes the methods provided by the LuaDocument object. A LuaDocument allows you to access and modify the reference, metadata and content of a document. If you have a LuaDocument object called document you can call its methods using the \u0027:\u0027 operator. For example: ..."},"461":{y:0,u:"../Content/Lua/LuaDocument/_LUA_addField.htm",l:-1,t:"addField",i:0.000270011625587733,a:"addField The addField method adds a new field to the document. Syntax addField ( fieldname, fieldvalue ) Arguments Returns (LuaField) A LuaField object representing the new field."},"462":{y:0,u:"../Content/Lua/LuaDocument/_LUA_addSection.htm",l:-1,t:"addSection",i:0.000270011625587733,a:"The addSection method adds an empty section to the end of the document. Syntax addSection() Returns (LuaDocument). Returns a LuaDocument object representing the document, with the new section as the active section. Example local newSection = document:addSection()   -- Add a new section to the ..."},"463":{y:0,u:"../Content/Lua/LuaDocument/_LUA_appendContent.htm",l:-1,t:"appendContent",i:0.000270011625587733,a:"The appendContent method appends content to the existing content (the DRECONTENT field) of a document  or document section. Syntax appendContent ( content [, number]) Arguments Examples \n-- Append content to the last section\ndocument:appendContent(\"content\")\n\n-- Append content to section 7, empty ..."},"464":{y:0,u:"../Content/Lua/LuaDocument/_LUA_copyField.htm",l:-1,t:"copyField",i:0.000270011625587733,a:"copyField The copyField method copies a field value to a new field. If the target field already exists it is overwritten. Syntax copyField ( sourcename, targetname [, case] ) Arguments"},"465":{y:0,u:"../Content/Lua/LuaDocument/_LUA_copyFieldNoOverwrite.htm",l:-1,t:"copyFieldNoOverwrite",i:0.000270011625587733,a:"The copyFieldNoOverwrite method copies a field value to a new field but does not overwrite the existing value. After calling this function the target field will contain all values of the source field in addition to any values it already had. Syntax copyFieldNoOverwrite( sourcename, targetname [, ..."},"466":{y:0,u:"../Content/Lua/LuaDocument/_LUA_countField.htm",l:-1,t:"countField",i:0.000270011625587733,a:"countField The countField method returns the number of fields with the specified name. Syntax countField( fieldname [, case] ) Arguments Returns (Number) The number of fields with the specified name."},"467":{y:0,u:"../Content/Lua/LuaDocument/_LUA_deleteField.htm",l:-1,t:"deleteField",i:0.000270011625587733,a:"deleteField The deleteField method deletes a field from a document. If you specify the optional value argument, the field is deleted only if has the specified value. Syntax deleteField( fieldName [, case] ) deleteField( fieldName, value [, case] ) Arguments"},"468":{y:0,u:"../Content/Lua/LuaDocument/_LUA_deleteFieldByPath.htm",l:-1,t:"deleteFieldByPath",i:0.000270011625587733,a:"deleteFieldByPath The deleteFieldByPath method removes all document fields with the specified path. Syntax deleteFieldByPath( path ) Arguments Example document:deleteFieldByPath(\"my/metadata/subfield\")"},"469":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getContent.htm",l:-1,t:"getContent",i:0.000270011625587733,a:"The getContent method gets the content (the value of the DRECONTENT field) for a document or document section. Syntax getContent([number]) Arguments Returns (String). The document content as a string. Examples \nlocal content7 = document:getContent(7)     -- Get content for section 7\nlocal section = ..."},"470":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getField.htm",l:-1,t:"getField",i:0.000270011625587733,a:"getField The getField method returns a LuaField object representing the field with the specified name. Syntax getField( name [, case]) Arguments Returns (LuaField). A LuaField object."},"471":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldNames.htm",l:-1,t:"getFieldNames",i:0.000270011625587733,a:"getFieldNames The getFieldNames method returns all of the field names for the document. Syntax getFieldNames() Returns (Strings) The names of the fields. To map the return values to a table, surround the function call with braces. For example: names = { document:getFieldNames() }"},"472":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFields.htm",l:-1,t:"getFields",i:0.000270011625587733,a:"The getFields method returns LuaField objects where each object represents a field that matches the specified name. Syntax getFields( name [, case]) Arguments Returns (LuaFields) One LuaField for each matching field. To map the return values to a table, surround the function call with braces. For ..."},"473":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldsByRegex.htm",l:-1,t:"getFieldsByRegex",i:0.000270011625587733,a:"The getFieldsByRegex method returns all document fields where the field name or path matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField represents a matching ..."},"474":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldValue.htm",l:-1,t:"getFieldValue",i:0.000270011625587733,a:"getFieldValue The getFieldValue method gets the value of a field in a document. To return the values of a multi-value field, see  getFieldValues . Syntax getFieldValue( fieldname [, case]) Arguments Returns (String). A string containing the value."},"475":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldValues.htm",l:-1,t:"getFieldValues",i:0.000499521571876599,a:"The getFieldValues method gets all values from all fields that have the same name. Syntax getFieldValues( fieldname [, case]) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ..."},"476":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getNextSection.htm",l:-1,t:"getNextSection",i:0.000270011625587733,a:"The getNextSection method returns the next section of a document (if the document has been divided into sections). The document object passed to the script\u0027s handler function represents the first section of the document. This means that the methods described in this section read and modify only the ..."},"477":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getReference.htm",l:-1,t:"getReference",i:0.000270011625587733,a:"getReference The getReference method returns a string containing the reference (the value of the DREREFERENCE document field). Syntax getReference() Returns (String). A string containing the reference."},"478":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getSection.htm",l:-1,t:"getSection",i:0.000270011625587733,a:"The getSection method returns a LuaDocument object with the specified section as the active section. Syntax getSection(number) Arguments Returns (LuaDocument). A LuaDocument object with the specified section as the active section. Example -- Get object for section 7 of document\nlocal section = ..."},"479":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getSectionCount.htm",l:-1,t:"getSectionCount",i:0.000270011625587733,a:"getSectionCount The getSectionCount method returns the number of sections in a document. Syntax getSectionCount() Returns (Number). The number of sections. Example local sectionCount = document:getSectionCount()"},"480":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getValueByPath.htm",l:-1,t:"getValueByPath",i:0.000270011625587733,a:"The getValueByPath method gets the value of a document field.  The field is specified by its path, which means that you can get the value of a sub field. If you pass this method the path of a multi-value field, only the first value is returned. To return all of the values from a multi-value field, ..."},"481":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getValuesByPath.htm",l:-1,t:"getValuesByPath",i:0.000499521571876599,a:"The getValuesByPath method gets all values of a document field. The field is specified by its path, which means that you can get values from a sub field. Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the ..."},"482":{y:0,u:"../Content/Lua/LuaDocument/_LUA_hasField.htm",l:-1,t:"hasField",i:0.000270011625587733,a:"hasField The hasField method checks to see if a field exists in the current document. Syntax hasField ( fieldname [, case]) Arguments Returns (Boolean). True if the field exists, false otherwise."},"483":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertJson.htm",l:-1,t:"insertJson",i:0.000346278519055324,a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into a document. Syntax insertJson ( json [, fieldName] ) Arguments Example The following example Lua script uses the insertJson method to add metadata to a document: function handler(document)\n  local ..."},"484":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertXml.htm",l:-1,t:"insertXml",i:0.000270011625587733,a:"insertXml The insertXml method inserts XML metadata into the document. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data."},});