define({"654":{i:0.000511399391066722,u:"../Content/Lua/LuaHttpRequest/_LUA__LuaHttpRequest.htm",a:"This section describes the methods provided by LuaHttpRequest objects. If you have a LuaHttpRequest object called request you can call its methods using the \u0027:\u0027 operator. For example: request:send() Method Description send Sends the HTTP request. set_body Sets the body of the HTTP request. ...",t:"LuaHttpRequest Methods"},"655":{i:0.000442606498336111,u:"../Content/Lua/LuaHttpRequest/_LUA_LuaHttpRequest_new.htm",a:"The constructor for a LuaHttpRequest object (creates a new LuaHttpRequest). Syntax LuaHttpRequest:new( config, section ) Arguments Returns (LuaHttpRequest). The new LuaHttpRequest object. Example The following example creates a new LuaHttpRequest object by reading configuration settings from a ...",t:"LuaHttpRequest:new"},"656":{i:0.000565735621055002,u:"../Content/Lua/LuaHttpRequest/_LUA_send.htm",a:"The send method sends the HTTP request. Syntax send() Returns (LuaHttpResponse). A  LuaHttpResponse  object. The send method can throw an exception if the request fails. You can catch an exception by calling the method  using the Lua function pcall. Example The following example shows how to send a ...",t:"send"},"657":{i:0.000442606498336111,u:"../Content/Lua/LuaHttpRequest/_LUA_set_body.htm",a:"set_body The set_body method sets the body of the HTTP request. Syntax set_body( body ) Arguments",t:"set_body"},"658":{i:0.000442606498336111,u:"../Content/Lua/LuaHttpRequest/_LUA_set_config.htm",a:"The set_config method specifies settings to use for sending the HTTP request (in the form of a section from a configuration file). For example, you can specify the proxy server to use by setting the parameters ProxyHost and ProxyPort, or specify the SSL version to use by setting SSLMethod. Syntax ...",t:"set_config"},"659":{i:0.000818822304706549,u:"../Content/Lua/LuaHttpRequest/_LUA_set_header.htm",a:"set_header The set_header method adds a header to the HTTP request. Syntax set_header( name, value ) Arguments Example request:set_header(\"X-EXAMPLE\", \"Example\")",t:"set_header"},"660":{i:0.000442606498336111,u:"../Content/Lua/LuaHttpRequest/_LUA_set_headers.htm",a:"set_headers The set_headers method replaces all headers in the HTTP request with new headers. To add a header without changing existing headers, use the method  set_header . Syntax set_headers( headers ) Arguments Example request:set_headers( {X-EXAMPLE=\"Example\", X-ANOTHER=\"ANOTHER\"} )",t:"set_headers"},"661":{i:0.000442606498336111,u:"../Content/Lua/LuaHttpRequest/_LUA_set_method.htm",a:"set_method Specifies the HTTP request method to use when sending the request, for example GET or POST.  Syntax set_method( method ) Arguments Example request:set_method(\"POST\")",t:"set_method"},"662":{i:0.000442606498336111,u:"../Content/Lua/LuaHttpRequest/_LUA_set_url.htm",a:"set_url The set_url method sets the URL that you want to send the HTTP request to. Syntax set_url( url ) Arguments Example request:set_url(\"https://www.example.com/\")",t:"set_url"},"663":{i:0.000869145952390547,u:"../Content/Lua/LuaHttpResponse/_LUA__LuaHttpResponse.htm",a:"This section describes the methods provided by LuaHttpResponse objects. A LuaHttpResponse object is provided when you send an HTTP request using the  send  method on a  LuaHttpRequest  object. If you have a LuaHttpResponse object called response you can call its methods using the \u0027:\u0027 operator. For ...",t:"LuaHttpResponse Methods"},"664":{i:0.000511399391066722,u:"../Content/Lua/LuaHttpResponse/_LUA_get_body.htm",a:"get_body The get_body method returns the body of the HTTP response. Syntax get_body() Returns (String). The body of the HTTP response.",t:"get_body"},"665":{i:0.000511399391066722,u:"../Content/Lua/LuaHttpResponse/_LUA_get_header.htm",a:"get_header The get_header method returns the value of a specified HTTP header. Syntax get_header( name ) Arguments Returns (String). The value of the header.",t:"get_header"},"666":{i:0.000511399391066722,u:"../Content/Lua/LuaHttpResponse/_LUA_get_headers.htm",a:"The get_headers method returns the names and values of all of the headers in the HTTP response. Syntax get_headers() Returns (table) A table that maps header names to values. Example The following example sends an HTTP request and then prints the headers that are returned to the console: local ...",t:"get_headers"},"667":{i:0.000511399391066722,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found.",t:"get_http_code"},"668":{i:0.00217549094394635,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Method Description append Appends a value to the array. clear Clears the array, so that it contains no values. copy ...",t:"LuaJsonArray Methods"},"669":{i:0.000542367697177516,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Returns (LuaJsonArray). The new LuaJsonArray object. Example The following is a simple JSON array: [4, \"a string\", true] To create a LuaJsonArray object to represent this array: local ...",t:"LuaJsonArray:new"},"670":{i:0.000542367697177516,u:"../Content/Lua/LuaJsonArray/_LUA_append.htm",a:"append The append method appends a value to the JSON array. Syntax append( value ) Arguments Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:append(6)\n-- the array is now [4, \"a string\", true, 6]",t:"append"},"671":{i:0.000542367697177516,u:"../Content/Lua/LuaJsonArray/_LUA_clear.htm",a:"clear The clear method clears the array, so that it contains no values. Syntax clear() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:clear()\nprint (myJsonArray:string())\n-- []",t:"clear"},"672":{i:0.000542367697177516,u:"../Content/Lua/LuaJsonArray/_LUA_copy.htm",a:"The copy method returns a copy of the array. Modifying the copy does not modify the original array. Syntax copy() Returns (LuaJsonArray). A copy of the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nlocal anotherJsonArray = myJsonArray:copy()\nprint ...",t:"copy"},"673":{i:0.000542367697177516,u:"../Content/Lua/LuaJsonArray/_LUA_empty.htm",a:"The empty method checks whether the JSON array is empty. Syntax empty() Returns (Boolean). Returns true if the array is empty. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nprint (\"Is the array empty?  \" , myJsonArray:empty() )\n-- Is the array empty?   ...",t:"empty"},"674":{i:0.00361572588081017,u:"../Content/Lua/LuaJsonArray/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON array. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ...",t:"exists"},"675":{i:0.00361572588081017,u:"../Content/Lua/LuaJsonArray/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON array. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ...",t:"existsByPath"},"676":{i:0.000542367697177516,u:"../Content/Lua/LuaJsonArray/_LUA_ipairs.htm",a:"The ipairs method returns a function that you can use with a for loop to iterate over all of the values in the array. Syntax ipairs() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nfor i, v in myJsonArray:ipairs() do\n  print (v:string())\nend\n\n-- prints the following...\n-- 4\n-- a ...",t:"ipairs"},"677":{i:0.00361572588081017,u:"../Content/Lua/LuaJsonArray/_LUA_lookup.htm",a:"The lookup method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ...",t:"lookup"},"678":{i:0.00361572588081017,u:"../Content/Lua/LuaJsonArray/_LUA_lookupByPath.htm",a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ...",t:"lookupByPath"},"679":{i:0.000542367697177516,u:"../Content/Lua/LuaJsonArray/_LUA_size.htm",a:"size The size method returns the size of the JSON array. Syntax size() Returns (integer). The number of values in the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nprint (\"Array size is \" , myJsonArray:size() )\n-- Array size is 3",t:"size"},"680":{i:0.000542367697177516,u:"../Content/Lua/LuaJsonArray/_LUA_string.htm",a:"The string method returns the JSON array as a string. Syntax string() Returns (String). The array as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = LuaJsonArray:new(\"zero\",1,2,myJsonObject)\n\nprint (myJsonArray:string())\n-- ...",t:"string"},"681":{i:0.00217549094394635,u:"../Content/Lua/LuaJsonObject/_LUA__LuaJsonObject.htm",a:"A LuaJsonObject object represents a JSON object. If you have a LuaJsonObject object called object you can call its methods using the \u0027:\u0027 operator. For example: object:size() Method Description assign Adds an attribute (a name/value pair) to the object. assign Adds a table of attributes (name/value ...",t:"LuaJsonObject Methods"},"682":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_LuaJsonObject_new.htm",a:"The constructor for a LuaJsonObject object (creates a new LuaJsonObject). If you do not specify any attributes to assign to the object (by omitting the attributes argument), an empty object is created. Syntax LuaJsonObject:new( [attributes] ) Arguments Returns (LuaJsonObject). The new LuaJsonObject ...",t:"LuaJsonObject:new"},"683":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_assign.htm",a:"The assign method adds an attribute (a name/value pair) to the object. Syntax assign (name, value) Arguments Example local myJsonObject = LuaJsonObject:new( { name1=\"value1\" , name2=\"value2\" } )\nmyJsonObject:assign(\"name3\", \"value3\")\nmyJsonObject:assign(\"name4\", LuaJsonArray:new(\"value4a\",\"value4b\") ...",t:"assign"},"684":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_assign2.htm",a:"The assign method adds a table of attributes (name/value pairs) to the object. Syntax assign (attributes) Arguments Example local myJsonObject = LuaJsonObject:new()\nmyJsonObject:assign( {\n        attr1=LuaJsonObject:new( { n=42 } ),\n        attr2=LuaJsonArray:new( 1, 2, \"three\" ),\n        ...",t:"assign"},"685":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_clear.htm",a:"clear The clear method clears the object, so that it contains no attributes (name/value pairs). Syntax clear() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:clear()\nprint (myJsonObject:string())\n-- {}",t:"clear"},"686":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_copy.htm",a:"The copy method returns a copy of the JSON object. Modifying the copy does not modify the original object. Syntax copy() Returns (LuaJsonObject). A copy of the object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal anotherJsonObject = ...",t:"copy"},"687":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_empty.htm",a:"empty The empty method determines whether the JSON object is empty. Syntax empty() Returns (Boolean). Returns true if the object has no attributes (name/value pairs). Example local myJsonObject = LuaJsonObject:new()\nprint(myJsonObject:empty())\n-- true\n",t:"empty"},"688":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_erase.htm",a:"erase The erase method removes a specified attribute (name/value pair) from the JSON object. Syntax erase( name ) Arguments Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:erase(\"version\")\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\"}",t:"erase"},"689":{i:0.00346896971332215,u:"../Content/Lua/LuaJsonObject/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON object. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"exists"},"690":{i:0.00346896971332215,u:"../Content/Lua/LuaJsonObject/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON object. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"existsByPath"},"691":{i:0.00346896971332215,u:"../Content/Lua/LuaJsonObject/_LUA_lookup.htm",a:"The lookup method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ...",t:"lookup"},"692":{i:0.00346896971332215,u:"../Content/Lua/LuaJsonObject/_LUA_lookupByPath.htm",a:"The lookupByPath method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ...",t:"lookupByPath"},"693":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_pairs.htm",a:"The pairs method returns an iterator function that you can use with a for loop to iterate over all of the attributes contained in the JSON object. Syntax pairs() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\n\nfor i, v in myJsonObject:pairs() do\n  print (i .. \u0027=\u0027 ...",t:"pairs"},"694":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_size.htm",a:"size The size method returns the number of attributes (name/value pairs) in the JSON object. Syntax size() Returns (Number). The number of attributes in the JSON object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:size())\n-- 2",t:"size"},"695":{i:0.000520353778773276,u:"../Content/Lua/LuaJsonObject/_LUA_string.htm",a:"string The string method returns the JSON object as a string. Syntax string() Returns (String). The JSON object as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\",\"version\":11}",t:"string"},"696":{i:0.00182121208127309,u:"../Content/Lua/LuaJsonValue/_LUA__LuaJsonValue.htm",a:"A LuaJsonValue object represents a JSON value.  If you have a LuaJsonValue object called myJsonValue you can call its methods using the \u0027:\u0027 operator. For example: myJsonValue:is_object() Method Description array Gets a LuaJsonArray that represents the JSON array, if the value is an array. copy ...",t:"LuaJsonValue Methods"},"697":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_LuaJsonValue_new.htm",a:"LuaJsonValue:new The constructor for a LuaJsonValue object (creates a new LuaJsonValue). Syntax LuaJsonValue:new( value ) Arguments Returns (LuaJsonValue). The new LuaJsonValue object.",t:"LuaJsonValue:new"},"698":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_array.htm",a:"The array method gets the array, if the value is a JSON array. Syntax array() Returns (LuaJsonArray). A  LuaJsonArray  object that represents the array. Example local fh = io.open(\"example_array.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = ...",t:"array"},"699":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_copy.htm",a:"copy The copy method returns a copy of the value. Modifying the copy does not affect the original value. Syntax copy() Returns (LuaJsonValue). A copy of the value.",t:"copy"},"700":{i:0.0031315893705117,u:"../Content/Lua/LuaJsonValue/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON value. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"exists"},"701":{i:0.0031315893705117,u:"../Content/Lua/LuaJsonValue/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON value.  Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"existsByPath"},"702":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_array.htm",a:"is_array The is_array method whether the value is a JSON array. Syntax is_array() Returns (Boolean). Returns true if the value is an array value, false otherwise.",t:"is_array"},"703":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_boolean.htm",a:"is_boolean The is_boolean method returns whether the value is a Boolean value. Syntax is_boolean() Returns (Boolean). Returns true if the value is a Boolean value, false otherwise.",t:"is_boolean"},"704":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_float.htm",a:"is_float The is_float method returns whether the value is a floating point value. Syntax is_float() Returns (Boolean). Returns true if the value is a floating point value, false otherwise.",t:"is_float"},"705":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_integer.htm",a:"is_integer The is_integer method returns whether the value is an integral value. Syntax is_integer() Returns (Boolean). Returns true if the value is an integer value, false otherwise.",t:"is_integer"},"706":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_null.htm",a:"is_null The is_null method returns whether the value is a null value. Syntax is_null() Returns (Boolean). Returns true if the value is a null value, false otherwise.",t:"is_null"},"707":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_number.htm",a:"is_number The is_number method returns whether the value is a number. Syntax is_number() Returns (Boolean). Returns true if the value is a number, false otherwise.",t:"is_number"},"708":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_object.htm",a:"is_object The is_object method returns whether the value is a JSON object. Syntax is_object() Returns (Boolean). Returns true if the value is a JSON object, false otherwise.",t:"is_object"},"709":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_simple_value.htm",a:"is_simple_value The is_simple_value method returns whether the value is a simple value (Boolean, float, integer, or string). Syntax is_simple_value() Returns (Boolean). Returns true if the value is a simple value, false otherwise.",t:"is_simple_value"},"710":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_is_string.htm",a:"is_string The is_string method returns whether the value is a string value. Syntax is_string() Returns (Boolean). Returns true if the value is a string value, false otherwise.",t:"is_string"},"711":{i:0.0031315893705117,u:"../Content/Lua/LuaJsonValue/_LUA_lookup.htm",a:"The lookup method returns the value at the specified path in the JSON value. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ...",t:"lookup"},"712":{i:0.0031315893705117,u:"../Content/Lua/LuaJsonValue/_LUA_lookupByPath.htm",a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ...",t:"lookupByPath"},"713":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_object.htm",a:"The object method gets the object, if the value is a JSON object. Syntax object() Returns (LuaJsonObject) A  LuaJsonObject  object that represents the JSON object. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n\nlocal myJsonValue = ...",t:"object"},"714":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_string.htm",a:"The string method returns the JSON value as a string. Syntax string() Returns (String). The JSON value as a string. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = parse_json(file_content)\n\nprint(myJsonValue:string())\n",t:"string"},"715":{i:0.00046974562897813,u:"../Content/Lua/LuaJsonValue/_LUA_value.htm",a:"The value method gets the value, if the JSON value is a simple type (a Boolean, float, integer, or string). This method returns a default value if one is specified and the value cannot be converted to the same type as the default. Syntax value( [default] ) Arguments Returns (lua_json_simple_type). A ...",t:"value"},"716":{i:0.00285113473703952,u:"../Content/Lua/LuaLog/_LUA_LuaLog.htm",a:"LuaLog Methods A LuaLog object provides the capability to use a log stream. You can obtain a LuaLog object for a log stream by using the function  get_log . If you have a LuaLog object called log you can call its methods using the \u0027:\u0027 operator. For example: log:write_line(level, message)",t:"LuaLog Methods"},"717":{i:0.00160000450544996,u:"../Content/Lua/LuaLog/_LUA_write_line.htm",a:"The write_line method writes a message to the log stream. Syntax write_line( level, message ) Arguments Example local config = get_config(\"connector.cfg\")\nlocal log = get_log(config, \"SynchronizeLogStream\")\nlog:write_line( log_level_error() , \"This message is written to the synchronize log\")",t:"write_line"},"718":{i:0.000514736701029113,u:"../Content/Lua/LuaLogService/_LUA__LuaLogService.htm",a:"A LuaLogService object provides the capability to write messages to a standard or custom log file. If you have a LuaLogService object called myLogService you can call its methods using the \u0027:\u0027 operator. For example: myLogService:get_log(\"application\") Method Description get_log Returns a LuaLog ...",t:"LuaLogService Methods"},"719":{i:0.000607033539138663,u:"../Content/Lua/LuaLogService/_LUA_LuaLogService_new.htm",a:"The constructor for a LuaLogService object (creates a new LuaLogService). Do not create a new log service to write messages to log types that are defined in the SharePoint Remote Connector configuration file. Instead use the same log service as SharePoint Remote Connector, by calling  ...",t:"LuaLogService:new"},"720":{i:0.000607033539138663,u:"../Content/Lua/LuaLogService/_LUA_get_log.htm",a:"get_log The get_log method returns a LuaLog object that you can use to write log messages to a specified log type. Syntax get_log( type ) Arguments Returns (LuaLog). A  LuaLog  object. Example local log = myLuaLogService:get_log(\"import\")\n-- import is a standard log type for CFS",t:"get_log"},"721":{i:0.000388270268347832,u:"../Content/Lua/LuaRegexMatch/_LUA_LuaRegexMatch_Methods.htm",a:"A LuaRegexMatch object provides information about the matches for a regular expression found in a string. For example, the regex_search function returns a LuaRegexMatch object. If a match is found for a regular expression at multiple points in the string, you can use the next() method to get a ...",t:"LuaRegexMatch Methods"},"722":{i:0.000454276260794623,u:"../Content/Lua/LuaRegexMatch/_LUA_length.htm",a:"length The length method returns the length of the match. You can also retrieve the length of sub matches by specifying the submatch parameter. Syntax length( [ submatch ] ) Arguments Returns (Number). The length of the sub match.",t:"length"},"723":{i:0.000454276260794623,u:"../Content/Lua/LuaRegexMatch/_LUA_next.htm",a:"next The next method returns a LuaRegexMatch object for the next match. Syntax next() Returns (LuaRegexMatch). A LuaRegexMatch object for the next match, or nil if there are no matches following this one.",t:"next"},"724":{i:0.000454276260794623,u:"../Content/Lua/LuaRegexMatch/_LUA_position.htm",a:"The position method returns the position of the match in the string searched, where 1 refers to the first character in the string. You can also retrieve the position of sub matches by specifying the submatch parameter. Syntax position( [ submatch ] ) Arguments Returns (Number). The position of the ...",t:"position"},"725":{i:0.000454276260794623,u:"../Content/Lua/LuaRegexMatch/_LUA_size.htm",a:"size The size method returns the total number of sub matches made for the current match, including the whole match (sub match 0). Syntax size() Returns (Number). The number of sub matches for the current match.",t:"size"},"726":{i:0.000454276260794623,u:"../Content/Lua/LuaRegexMatch/_LUA_str.htm",a:"str The str method returns the value of the substring that matched the regular expression. You can also retrieve the values of sub matches by specifying the submatch parameter. Syntax str( [ submatch ] ) Arguments Returns (String). The value of the sub match.",t:"str"},"727":{i:0.000388270268347832,u:"../Content/Lua/LuaXmlDocument/_LUA_LuaXmlDocument_Methods.htm",a:"This section describes the methods provided by LuaXmlDocument objects. A LuaXmlDocument object provides methods for accessing information stored in XML format. You can create a LuaXmlDocument from a string containing XML using the parse_xml function. If you have a LuaXmlDocument object called xml ...",t:"LuaXmlDocument Methods"},"728":{i:0.000454276260794623,u:"../Content/Lua/LuaXmlDocument/_LUA_root.htm",a:"root The root method returns an LuaXmlNode, which is the root node of the XML document. Syntax root() Returns (LuaXmlNode). A LuaXmlNode object.",t:"root"},"729":{i:0.000454276260794623,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathExecute.htm",a:"XPathExecute The XPathExecute method returns a LuaXmlNodeSet, which is the result of the supplied XPath query. Syntax XPathExecute( xpathQuery ) Arguments Returns (LuaXmlNodeSet). A LuaXmlNodeSet object.",t:"XPathExecute"},"730":{i:0.000454276260794623,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathRegisterNs.htm",a:"XPathRegisterNs The XPathRegisterNs method registers a namespace with the XML parser. Syntax XPathRegisterNs( prefix, location ) Arguments Returns (Boolean). True if successful, False in case of error.",t:"XPathRegisterNs"},"731":{i:0.000454276260794623,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValue.htm",a:"XPathValue The XPathValue method returns the first occurrence of the value matching the XPath query. Syntax XPathValue( query ) Arguments Returns (String). A string of the value.",t:"XPathValue"},"732":{i:0.000454276260794623,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValues.htm",a:"The XPathValues method returns the values according to the XPath query. Syntax XPathValues( query ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: values = { xml:XPathValues(query) }",t:"XPathValues"},"733":{i:0.000388270268347832,u:"../Content/Lua/LuaXmlNodeSet/_LUA_LuaXmlNodeSet_Methods.htm",a:"LuaXmlNodeSet Methods A LuaXmlNodeSet object represents a set of XML nodes. If you have a LuaXmlNodeSet object called nodes you can call its methods using the \u0027:\u0027 operator. For example: nodes:size()",t:"LuaXmlNodeSet Methods"},"734":{i:0.000553285249464809,u:"../Content/Lua/LuaXmlNodeSet/_LUA_at.htm",a:"at The at method returns the LuaXmlNode at position position in the set. Syntax at( position ) Arguments Returns (LuaXmlNode).",t:"at"},"735":{i:0.000553285249464809,u:"../Content/Lua/LuaXmlNodeSet/_LUA_size.htm",a:"size The size method returns the size of the node set. Syntax size() Returns (Number) An integer, the size of the node set.",t:"size"},"736":{i:0.000388270268347832,u:"../Content/Lua/LuaXmlNode/_LUA_LuaXmlNode_Methods.htm",a:"LuaXmlNode Methods A LuaXmlNode object represents a single node in an XML document.  If you have a LuaXmlNode object called node you can call its methods using the \u0027:\u0027 operator. For example: node:name()",t:"LuaXmlNode Methods"},"737":{i:0.000421273264571227,u:"../Content/Lua/LuaXmlNode/_LUA_attr.htm",a:"attr The attr method returns the first LuaXmlAttribute attribute object for the LuaXmlNode. If the name argument is specified, the method returns the first LuaXmlAttribute object with the specified name. Syntax attr( [name] ) Arguments Returns (LuaXmlAttribute). ",t:"attr"},});