define({"256":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_getFieldsByRegex.htm",a:"The getFieldsByRegex method returns all document fields where the field name or path matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField represents a matching ...",t:"getFieldsByRegex"},"257":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_getFieldValue.htm",a:"getFieldValue The getFieldValue method gets the value of a field in a document. To return the values of a multi-value field, see  getFieldValues . Syntax getFieldValue( fieldname [, case]) Arguments Returns (String). A string containing the value.",t:"getFieldValue"},"258":{i:0.00147036668890812,u:"../Content/Lua/LuaDocument/_LUA_getFieldValues.htm",a:"The getFieldValues method gets all values from all fields that have the same name. Syntax getFieldValues( fieldname [, case]) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ...",t:"getFieldValues"},"259":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_getNextSection.htm",a:"The getNextSection method returns the next section of a document (if the document has been divided into sections). The document object passed to the script\u0027s handler function represents the first section of the document. This means that the methods described in this section read and modify only the ...",t:"getNextSection"},"260":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_getReference.htm",a:"getReference The getReference method returns a string containing the reference (the value of the DREREFERENCE document field). Syntax getReference() Returns (String). A string containing the reference.",t:"getReference"},"261":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_getSection.htm",a:"The getSection method returns a LuaDocument object with the specified section as the active section. Syntax getSection(number) Arguments Returns (LuaDocument). A LuaDocument object with the specified section as the active section. Example -- Get object for section 7 of document\nlocal section = ...",t:"getSection"},"262":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_getSectionCount.htm",a:"getSectionCount The getSectionCount method returns the number of sections in a document. Syntax getSectionCount() Returns (Number). The number of sections. Example local sectionCount = document:getSectionCount()",t:"getSectionCount"},"263":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_getValueByPath.htm",a:"The getValueByPath method gets the value of a document field.  The field is specified by its path, which means that you can get the value of a sub field. If you pass this method the path of a multi-value field, only the first value is returned. To return all of the values from a multi-value field, ...",t:"getValueByPath"},"264":{i:0.00147036668890812,u:"../Content/Lua/LuaDocument/_LUA_getValuesByPath.htm",a:"The getValuesByPath method gets all values of a document field. The field is specified by its path, which means that you can get values from a sub field. Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the ...",t:"getValuesByPath"},"265":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_hasField.htm",a:"hasField The hasField method checks to see if a field exists in the current document. Syntax hasField ( fieldname [, case]) Arguments Returns (Boolean). True if the field exists, false otherwise.",t:"hasField"},"266":{i:0.00101782326406409,u:"../Content/Lua/LuaDocument/_LUA_insertJson.htm",a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into a document. Syntax insertJson ( json [, fieldName] ) Arguments Example The following example Lua script uses the insertJson method to add metadata to a document: function handler(document)\n  local ...",t:"insertJson"},"267":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_insertXml.htm",a:"insertXml The insertXml method inserts XML metadata into the document. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data.",t:"insertXml"},"268":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_insertXmlWithoutRoot.htm",a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ...",t:"insertXmlWithoutRoot"},"269":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_new.htm",a:"The constructor for a LuaDocument object (creates a new LuaDocument object that only contains a reference). Syntax LuaDocument:new( reference ) Arguments Returns (LuaDocument). The new LuaDocument object. Example local reference = \"my_reference\"\nlocal document = LuaDocument:new(reference)",t:"LuaDocument:new"},"270":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_removeSection.htm",a:"The removeSection method removes a section from a document. Syntax removeSection( sectionNumber ) Arguments Returns Nothing. Example \n-- Example that removes the last section of a document\nif document:getSectionCount() \u003e 0 then\n   local lastSection = document:getSectionCount() - 1\n   ...",t:"removeSection"},"271":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_renameField.htm",a:"renameField The renameField method changes the name of a field. Syntax renameField( currentname, newname [, case]) Arguments",t:"renameField"},"272":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_setContent.htm",a:"The setContent method sets the content (the value of the DRECONTENT field) for a document or document section. Syntax setContent( content [, number] ) Arguments Examples \n-- Set content for section 0\ndocument:setContent(\"content0\")\n\n-- Get document for section 1\nlocal section = ...",t:"setContent"},"273":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_setFieldValue.htm",a:"setFieldValue The setFieldValue method sets the value of a field in a document. If the field does not exist, it is created. If the field already exists, the existing value is overwritten. Syntax setFieldValue( fieldname, newvalue ) Arguments",t:"setFieldValue"},"274":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_setReference.htm",a:"setReference The setReference method sets the reference (the value of the DREREFERENCE document field) to the string passed in. Syntax setReference( reference ) Arguments",t:"setReference"},"275":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_to_IDX.htm",a:"to_idx The to_idx method returns a string containing the document in IDX format. Syntax to_idx() Returns (String). Returns the document as a string.",t:"to_idx"},"276":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_to_JSON.htm",a:"to_json The to_json method returns a string containing the document in JSON format. Syntax to_json() Returns (String). Returns the document as a string.",t:"to_json"},"277":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_to_XML.htm",a:"to_xml The to_xml method returns a string containing the document in XML format. Syntax to_xml() Returns (String). Returns the document as a string.",t:"to_xml"},"278":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_writeStubIdx.htm",a:"The writeStubIdx method writes out a stub IDX document (a metadata file used by IDOL applications). The file is created in the current folder, but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubIdx( filename ) Arguments Returns (Boolean). ...",t:"writeStubIdx"},"279":{i:0.000794791918412793,u:"../Content/Lua/LuaDocument/_LUA_writeStubXml.htm",a:"The writeStubXml method writes out an XML file containing the metadata for the document. The file is created in the current folder but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubXml( filename ) Arguments Returns (Boolean) True if ...",t:"writeStubXml"},"280":{i:0.000761283847372972,u:"../Content/Lua/LuaField/_LUA_LuaField_Methods.htm",a:"This section describes the methods provided by LuaField objects. A LuaField represents a single field in a document. You can retrieve LuaField objects for a document using the LuaDocument getField and getFields methods. In its simplest form a field has just a name and a value, but it can also ...",t:"LuaField Methods"},"281":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_addField.htm",a:"addField The addField method adds a sub field with the specified name and value. Syntax addField( fieldname, fieldvalue ) Arguments",t:"addField"},"282":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_copyField.htm",a:"copyField The copyField method copies a sub field to another sub field. If the target sub field exists it is overwritten. Syntax copyField ( from, to [, case]) Arguments",t:"copyField"},"283":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_copyFieldNoOverwrite.htm",a:"The copyFieldNoOverwrite method copies the sub field to another sub field but does not overwrite the destination. After this operation the destination field contains all the values of the source field as well as any values it already had. Syntax copyFieldNoOverwrite( from, to [, case]) Arguments",t:"copyFieldNoOverwrite"},"284":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_countField.htm",a:"countField The countField method returns the number of sub fields that exist with the specified name. Syntax countField ( fieldname [, case]) Arguments Returns (Number). The number of sub fields that exist with the specified name.",t:"countField"},"285":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_deleteAttribute.htm",a:"deleteAttribute The deleteAttribute method deletes the specified field attribute. Syntax deleteAttribute( name ) Arguments",t:"deleteAttribute"},"286":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_deleteField.htm",a:"deleteField The deleteField method deletes the sub field with the specified name. Syntax deleteField( name [, case] )  deleteField( name , value [, case] )  Arguments",t:"deleteField"},"287":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_deleteFieldByPath.htm",a:"deleteFieldByPath The deleteFieldByPath method removes the sub field(s) with the specified path. Syntax deleteFieldByPath( path ) Arguments Example myField:deleteFieldByPath(\"path/to/subfield\")",t:"deleteFieldByPath"},"288":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_getAttributeValue.htm",a:"getAttributeValue The getAttributeValue method gets the value of the specified attribute. Syntax getAttributeValue( name ) Arguments Returns (String). The attribute value.",t:"getAttributeValue"},"289":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_getField.htm",a:"getField The getField method returns the specified sub field. Syntax getField ( name [, case]) Arguments Returns (LuaField) A LuaField object.",t:"getField"},"290":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_getFieldNames.htm",a:"The getFieldNames method returns the names of the sub fields in the LuaField object. Syntax getFieldNames() Returns (Strings). The names of the sub fields. The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: fieldnames = { ...",t:"getFieldNames"},"291":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_getFields.htm",a:"The getFields method returns all of the sub fields specified by the name argument. Syntax getFields( name [, case] ) Arguments Returns (LuaFields) One LuaField per matching field. The objects can be assigned to a table. To map the return values to a table, surround the function call with braces. For ...",t:"getFields"},"292":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_getFieldsByRegex.htm",a:"The getFieldsByRegex method returns all sub fields where the sub field name or path (relative to this field) matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField ...",t:"getFieldsByRegex"},"293":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_getFieldValues.htm",a:"The getFieldValues method returns the values of all of the sub fields with the specified name. Syntax getFieldValues( fieldname [, case] ) Arguments Returns (Strings) One string for each value. The strings can be assigned to a table. To map the return values to a table, surround the function call ...",t:"getFieldValues"},"294":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_getValueByPath.htm",a:"The getValueByPath method gets the value of a sub-field, specified by path.   If you pass this method the path of a sub-field that has multiple values, only the first value is returned. To return all of the values from a multi-value sub-field, see  getValuesByPath . Syntax getValueByPath( path ) ...",t:"getValueByPath"},"295":{i:0.00145626159695317,u:"../Content/Lua/LuaField/_LUA_getValuesByPath.htm",a:"The getValuesByPath method gets the values of a sub-field, specified by path.   Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ...",t:"getValuesByPath"},"296":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_hasAttribute.htm",a:"hasAttribute The hasAttribute method returns a Boolean indicating whether the field has the specified attribute. Syntax hasAttribute( name ) Arguments Returns (Boolean). A Boolean specifying if the field has the specified attribute.",t:"hasAttribute"},"297":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_hasField.htm",a:"hasField The hasField method returns a Boolean specifying if the sub field exists. Syntax hasField( fieldname [, case]) Arguments Returns (Boolean). A Boolean specifying if the sub field exists or not.",t:"hasField"},"298":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_insertJson.htm",a:"insertJson The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into the field. Syntax insertJson ( json [, fieldName] ) Arguments See Also LuaDocument:insertJson",t:"insertJson"},"299":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_insertXml.htm",a:"insertXml The insertXml method inserts XML metadata into the document. When called on a LuaField, the insertXml method inserts the fields as children of the LuaField. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data.",t:"insertXml"},"300":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_insertXmlWithoutRoot.htm",a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ...",t:"insertXmlWithoutRoot"},"301":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_name.htm",a:"name The name method returns the name of the field object. Syntax name() Returns (String). The name of the field object.",t:"name"},"302":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_renameField.htm",a:"renameField The renameField method renames a sub field. Syntax renameField( oldname, newname [, case] ) Arguments",t:"renameField"},"303":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_setAttributeValue.htm",a:"setAttributeValue The setAttributeValue method sets the value for the specified attribute of the field. Syntax setAttributeValue( attribute, value ) Arguments",t:"setAttributeValue"},"304":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_setValue.htm",a:"setValue The setValue method sets the value of the field. Syntax setValue( value ) Arguments",t:"setValue"},"305":{i:0.000787167559999275,u:"../Content/Lua/LuaField/_LUA_value.htm",a:"value The value method returns the value of the field object. Syntax value() Returns (String). The value of the field object.",t:"value"},"306":{i:0.00100270475659187,u:"../Content/Lua/LuaHttpRequest/_LUA__LuaHttpRequest.htm",a:"This section describes the methods provided by LuaHttpRequest objects. If you have a LuaHttpRequest object called request you can call its methods using the \u0027:\u0027 operator. For example: request:send() Method Description send Sends the HTTP request. set_body Sets the body of the HTTP request. ...",t:"LuaHttpRequest Methods"},"307":{i:0.000867821516002256,u:"../Content/Lua/LuaHttpRequest/_LUA_LuaHttpRequest_new.htm",a:"The constructor for a LuaHttpRequest object (creates a new LuaHttpRequest). Syntax LuaHttpRequest:new( config, section ) Arguments Returns (LuaHttpRequest). The new LuaHttpRequest object. Example The following example creates a new LuaHttpRequest object by reading configuration settings from a ...",t:"LuaHttpRequest:new"},"308":{i:0.00110924242522116,u:"../Content/Lua/LuaHttpRequest/_LUA_send.htm",a:"The send method sends the HTTP request. Syntax send() Returns (LuaHttpResponse). A  LuaHttpResponse  object. The send method can throw an exception if the request fails. You can catch an exception by calling the method  using the Lua function pcall. Example The following example shows how to send a ...",t:"send"},"309":{i:0.000867821516002256,u:"../Content/Lua/LuaHttpRequest/_LUA_set_body.htm",a:"set_body The set_body method sets the body of the HTTP request. Syntax set_body( body ) Arguments",t:"set_body"},"310":{i:0.000867821516002256,u:"../Content/Lua/LuaHttpRequest/_LUA_set_config.htm",a:"The set_config method specifies settings to use for sending the HTTP request (in the form of a section from a configuration file). For example, you can specify the proxy server to use by setting the parameters ProxyHost and ProxyPort, or specify the SSL version to use by setting SSLMethod. Syntax ...",t:"set_config"},"311":{i:0.00160547165562088,u:"../Content/Lua/LuaHttpRequest/_LUA_set_header.htm",a:"set_header The set_header method adds a header to the HTTP request. Syntax set_header( name, value ) Arguments Example request:set_header(\"X-EXAMPLE\", \"Example\")",t:"set_header"},"312":{i:0.000867821516002256,u:"../Content/Lua/LuaHttpRequest/_LUA_set_headers.htm",a:"set_headers The set_headers method replaces all headers in the HTTP request with new headers. To add a header without changing existing headers, use the method  set_header . Syntax set_headers( headers ) Arguments Example request:set_headers( {X-EXAMPLE=\"Example\", X-ANOTHER=\"ANOTHER\"} )",t:"set_headers"},"313":{i:0.000867821516002256,u:"../Content/Lua/LuaHttpRequest/_LUA_set_method.htm",a:"set_method Specifies the HTTP request method to use when sending the request, for example GET or POST.  Syntax set_method( method ) Arguments Example request:set_method(\"POST\")",t:"set_method"},"314":{i:0.000867821516002256,u:"../Content/Lua/LuaHttpRequest/_LUA_set_url.htm",a:"set_url The set_url method sets the URL that you want to send the HTTP request to. Syntax set_url( url ) Arguments Example request:set_url(\"https://www.example.com/\")",t:"set_url"},"315":{i:0.00170414252036828,u:"../Content/Lua/LuaHttpResponse/_LUA__LuaHttpResponse.htm",a:"This section describes the methods provided by LuaHttpResponse objects. A LuaHttpResponse object is provided when you send an HTTP request using the  send  method on a  LuaHttpRequest  object. If you have a LuaHttpResponse object called response you can call its methods using the \u0027:\u0027 operator. For ...",t:"LuaHttpResponse Methods"},"316":{i:0.00100270475659187,u:"../Content/Lua/LuaHttpResponse/_LUA_get_body.htm",a:"get_body The get_body method returns the body of the HTTP response. Syntax get_body() Returns (String). The body of the HTTP response.",t:"get_body"},"317":{i:0.00100270475659187,u:"../Content/Lua/LuaHttpResponse/_LUA_get_header.htm",a:"get_header The get_header method returns the value of a specified HTTP header. Syntax get_header( name ) Arguments Returns (String). The value of the header.",t:"get_header"},"318":{i:0.00100270475659187,u:"../Content/Lua/LuaHttpResponse/_LUA_get_headers.htm",a:"The get_headers method returns the names and values of all of the headers in the HTTP response. Syntax get_headers() Returns (table) A table that maps header names to values. Example The following example sends an HTTP request and then prints the headers that are returned to the console: local ...",t:"get_headers"},"319":{i:0.00100270475659187,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found.",t:"get_http_code"},"320":{i:0.00426590852359211,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Method Description append Appends a value to the array. clear Clears the array, so that it contains no values. copy ...",t:"LuaJsonArray Methods"},"321":{i:0.00106345333872242,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Returns (LuaJsonArray). The new LuaJsonArray object. Example The following is a simple JSON array: [4, \"a string\", true] To create a LuaJsonArray object to represent this array: local ...",t:"LuaJsonArray:new"},"322":{i:0.00106345333872242,u:"../Content/Lua/LuaJsonArray/_LUA_append.htm",a:"append The append method appends a value to the JSON array. Syntax append( value ) Arguments Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:append(6)\n-- the array is now [4, \"a string\", true, 6]",t:"append"},"323":{i:0.00106345333872242,u:"../Content/Lua/LuaJsonArray/_LUA_clear.htm",a:"clear The clear method clears the array, so that it contains no values. Syntax clear() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:clear()\nprint (myJsonArray:string())\n-- []",t:"clear"},"324":{i:0.00106345333872242,u:"../Content/Lua/LuaJsonArray/_LUA_copy.htm",a:"The copy method returns a copy of the array. Modifying the copy does not modify the original array. Syntax copy() Returns (LuaJsonArray). A copy of the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nlocal anotherJsonArray = myJsonArray:copy()\nprint ...",t:"copy"},"325":{i:0.00106345333872242,u:"../Content/Lua/LuaJsonArray/_LUA_empty.htm",a:"The empty method checks whether the JSON array is empty. Syntax empty() Returns (Boolean). Returns true if the array is empty. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nprint (\"Is the array empty?  \" , myJsonArray:empty() )\n-- Is the array empty?   ...",t:"empty"},"326":{i:0.00708929665697654,u:"../Content/Lua/LuaJsonArray/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON array. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ...",t:"exists"},"327":{i:0.00708929665697654,u:"../Content/Lua/LuaJsonArray/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON array. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ...",t:"existsByPath"},"328":{i:0.00106345333872242,u:"../Content/Lua/LuaJsonArray/_LUA_ipairs.htm",a:"The ipairs method returns a function that you can use with a for loop to iterate over all of the values in the array. Syntax ipairs() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nfor i, v in myJsonArray:ipairs() do\n  print (v:string())\nend\n\n-- prints the following...\n-- 4\n-- a ...",t:"ipairs"},"329":{i:0.00708929665697654,u:"../Content/Lua/LuaJsonArray/_LUA_lookup.htm",a:"The lookup method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ...",t:"lookup"},"330":{i:0.00708929665697654,u:"../Content/Lua/LuaJsonArray/_LUA_lookupByPath.htm",a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ...",t:"lookupByPath"},"331":{i:0.00106345333872242,u:"../Content/Lua/LuaJsonArray/_LUA_size.htm",a:"size The size method returns the size of the JSON array. Syntax size() Returns (integer). The number of values in the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nprint (\"Array size is \" , myJsonArray:size() )\n-- Array size is 3",t:"size"},"332":{i:0.00106345333872242,u:"../Content/Lua/LuaJsonArray/_LUA_string.htm",a:"The string method returns the JSON array as a string. Syntax string() Returns (String). The array as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = LuaJsonArray:new(\"zero\",1,2,myJsonObject)\n\nprint (myJsonArray:string())\n-- ...",t:"string"},"333":{i:0.00426590852359211,u:"../Content/Lua/LuaJsonObject/_LUA__LuaJsonObject.htm",a:"A LuaJsonObject object represents a JSON object. If you have a LuaJsonObject object called object you can call its methods using the \u0027:\u0027 operator. For example: object:size() Method Description assign Adds an attribute (a name/value pair) to the object. assign Adds a table of attributes (name/value ...",t:"LuaJsonObject Methods"},"334":{i:0.00102028626852965,u:"../Content/Lua/LuaJsonObject/_LUA_LuaJsonObject_new.htm",a:"The constructor for a LuaJsonObject object (creates a new LuaJsonObject). If you do not specify any attributes to assign to the object (by omitting the attributes argument), an empty object is created. Syntax LuaJsonObject:new( [attributes] ) Arguments Returns (LuaJsonObject). The new LuaJsonObject ...",t:"LuaJsonObject:new"},"335":{i:0.00102028626852965,u:"../Content/Lua/LuaJsonObject/_LUA_assign.htm",a:"The assign method adds an attribute (a name/value pair) to the object. Syntax assign (name, value) Arguments Example local myJsonObject = LuaJsonObject:new( { name1=\"value1\" , name2=\"value2\" } )\nmyJsonObject:assign(\"name3\", \"value3\")\nmyJsonObject:assign(\"name4\", LuaJsonArray:new(\"value4a\",\"value4b\") ...",t:"assign"},"336":{i:0.00102028626852965,u:"../Content/Lua/LuaJsonObject/_LUA_assign2.htm",a:"The assign method adds a table of attributes (name/value pairs) to the object. Syntax assign (attributes) Arguments Example local myJsonObject = LuaJsonObject:new()\nmyJsonObject:assign( {\n        attr1=LuaJsonObject:new( { n=42 } ),\n        attr2=LuaJsonArray:new( 1, 2, \"three\" ),\n        ...",t:"assign"},"337":{i:0.00102028626852965,u:"../Content/Lua/LuaJsonObject/_LUA_clear.htm",a:"clear The clear method clears the object, so that it contains no attributes (name/value pairs). Syntax clear() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:clear()\nprint (myJsonObject:string())\n-- {}",t:"clear"},"338":{i:0.00102028626852965,u:"../Content/Lua/LuaJsonObject/_LUA_copy.htm",a:"The copy method returns a copy of the JSON object. Modifying the copy does not modify the original object. Syntax copy() Returns (LuaJsonObject). A copy of the object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal anotherJsonObject = ...",t:"copy"},"339":{i:0.00102028626852965,u:"../Content/Lua/LuaJsonObject/_LUA_empty.htm",a:"empty The empty method determines whether the JSON object is empty. Syntax empty() Returns (Boolean). Returns true if the object has no attributes (name/value pairs). Example local myJsonObject = LuaJsonObject:new()\nprint(myJsonObject:empty())\n-- true\n",t:"empty"},"340":{i:0.00102028626852965,u:"../Content/Lua/LuaJsonObject/_LUA_erase.htm",a:"erase The erase method removes a specified attribute (name/value pair) from the JSON object. Syntax erase( name ) Arguments Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:erase(\"version\")\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\"}",t:"erase"},"341":{i:0.00680153807644854,u:"../Content/Lua/LuaJsonObject/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON object. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"exists"},});