define({"0":{i:0.00360020707023554,u:"../Content/Tutorial/Introduction.htm",a:"Connectors provide the connection between IDOL and the repositories that your organization uses for storing and organizing information. You can use connectors to keep your IDOL index up-to-date with the information in a repository (using the synchronize fetch action) and to retrieve files, or lists ...",t:"Introduction"},"1":{i:0.000540044625242238,u:"../Content/ConnectorLib_Tutorial.htm",a:"ConnectorLib C++ Tutorial This section shows how to use the ConnectorLib C++ SDK to build a connector.",t:"ConnectorLib C++ Tutorial"},"2":{i:0.000540044625242238,u:"../Content/Tutorial/Prerequisites.htm",a:"Before you can run some of the code samples in the ConnectorLib C++ SDK, you must obtain some third-party libraries and set some environment variables: Code sample Required third-party libraries Environment Variables Example File System Connector Boost SQLite BOOST_DIR - the directory that contains ...",t:"Prerequisites"},"3":{i:0.00128215704404223,u:"../Content/Tutorial/Implement.htm",a:"Implement a New Connector This section describes how to implement a new connector.",t:"Implement a New Connector"},"4":{i:0.000540044625242238,u:"../Content/Tutorial/Create_the_Visual_Studio.htm",a:"To create a new connector using Visual Studio, follow these steps: Create a new solution containing an empty Win32 DLL project. The project will contain the code for your connector. In the project properties, add the \"include\" path contained in the SDK to the list of Include Directories. Add a new ...",t:"Create the Visual Studio Solution"},"5":{i:0.000540044625242238,u:"../Content/Tutorial/Extend_ConnectorBase.htm",a:"To create a new connector, you must include the SDK header files in the source file.  Add the following include statement at the top of the source file you created: #include \u003cautonomy/connector/connector.hpp\u003e So that the required classes are conveniently accessible, add the following using statement ...",t:"Extend ConnectorBase"},"6":{i:0.0014581215976652,u:"../Content/Tutorial/RunConnector/Run_Introduction.htm",a:"Run the Connector This section describes how to run a new connector.",t:"Run the Connector"},"7":{i:0.000693057453979398,u:"../Content/Tutorial/RunConnector/Required_Files.htm",a:"To run the connector, you must place the following files in a directory (from now on called the connector directory). All of the files, except your connector  library , are provided with the SDK. Your connector  library (*.dll or lib*.so) , and any dependencies connectorLibCpp.cfg ...",t:"Required Files"},"8":{i:0.000693057453979398,u:"../Content/Tutorial/RunConnector/Configure.htm",a:"Before running the connector you must modify connectorLibCpp.cfg. In the [Connector] section of the configuration file, set the following parameter. This parameter tells ConnectorLib C++ how to locate your connector implementation: ConnectorLibrary The name of your connector library. The value of ...",t:"Configure the Connector"},"9":{i:0.000540044625242238,u:"../Content/Tutorial/RunConnector/RunConnector.htm",a:"After you have collected the  required files  and  configured the connector , you can run the connector by starting connectorLibCpp.exe. Install the Connector as a Service You can install the connector as a service using the -install command line option. For example: connectorLibCpp.exe -install ...",t:"Run the Connector"},"10":{i:0.000540044625242238,u:"../Content/Tutorial/RunConnector/Troubleshooting.htm",a:"If you run the connector and find that it stops immediately, check the logs to see if any errors occurred at the time you tried to start it. You can also try running the connector from the command prompt to see if any messages are output to the console.  The following table provides the solutions ...",t:"Troubleshoot Errors"},"11":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Documents_Introduction.htm",a:"Create and Ingest Documents This section describes how to create and ingest Documents using ConnectorLib C++.",t:"Create and Ingest Documents"},"12":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Documents_Intro.htm",a:"Much of what a connector does involves dealing with documents in some way. A document represents a single document in IDOL and has: A unique reference to identify it. A unique identifier for finding it in the repository. A set of key-value pairs for storing metadata. Optionally, a file storing the ...",t:"Introduction"},"13":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Create_a_Document.htm",a:"With ConnectorLib C++, you can create a new document using the createDocInfo(...) functions on an instance of the DocInfoBuilder class.  You can create the DocInfoBuilder from any ConnectorTask object.        DocInfoBuilder builder = task.docInfoBuilder();\n\n       DocInfo docInfo = ...",t:"Create a Document"},"14":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Add_Metadata.htm",a:"Often repositories store metadata about the files they contain, such as who created a file and when it was last modified. Metadata might also include repository-specific information. For example, a repository storing information about products for sale might include a price and a description for ...",t:"Add Metadata"},"15":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Metadata_only_Documents.htm",a:"To create a document that has metadata but no file, use a different overload of DocInfoBuilder::createDocInfo:        DocInfo docInfo = builder.createDocInfo(\n               \"http://www.example.com/metadataOnly\"); You might create a metadata-only document when items in a repository do not include ...",t:"Create Metadata-only Documents"},"16":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Identifiers.htm",a:"Although a document\u0027s reference should identify a unique file or item  in the repository, it might not be sufficient for the connector to retrieve it again efficiently (this might be necessary, for example, in response to a collect request). You can therefore add additional information to a ...",t:"Create Identifiers"},"17":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Ingest_a_Document.htm",a:"A connector\u0027s synchronize action typically involves retrieving files and associated metadata from a repository, creating documents from those files, and sending the documents  to the ingestion target, configured in the [Ingestion] section of the configuration file. Usually the target is a CFS, which ...",t:"Ingest a Document"},"18":{i:0.00144664573522229,u:"../Content/Tutorial/Documents/Ingest_Add.htm",a:"The Ingest Add method adds a new document to the ingestion target. You can create and ingest a document  like this:        DocInfo docInfo = task.docInfoBuilder().createDocInfo(\n          \"http://www.example.com/testDocument.doc\",\n          \"testDocument.doc\",\n          true);\n\n       Metadata ...",t:"Ingest Add"},"19":{i:0.00165770864434378,u:"../Content/Tutorial/Documents/Ingest_Remove.htm",a:"The Remove method deletes a document that has previously been ingested. Only the reference is required to do this:        task.ingester().remove(\"http://www.example.com/testDocument.doc\"); The synchronize action typically removes documents when the connector detects that a document has been removed ...",t:"Ingest Remove"},"20":{i:0.000693057453979398,u:"../Content/Tutorial/Documents/Ingest_Replace.htm",a:"The Replace method is short-hand for performing a  Remove  followed by an  Add. You can use this method when a document in a repository has been changed.        DocInfo docInfo = task.docInfoBuilder().createDocInfo(\n          \"http://www.example.com/testDocument.doc\",\n          \"testDocument.doc\",\n  ...",t:"Ingest Replace"},"21":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Ingest_Update.htm",a:"If a document has been ingested previously, and the metadata for the document has changed but the file content has not, you can use the Ingest Update method. This instructs the target to update the metadata for an existing document, but to leave the content intact. The following example updates just ...",t:"Ingest Update"},"22":{i:0.000540044625242238,u:"../Content/Tutorial/Documents/Ingest_Result_Handlers.htm",a:"When you ingest a document using the Add, Replace, Remove or Update methods, the ingest command is placed in a queue and the method returns immediately. ConnectorLib C++ takes care of batching, sending the commands, and dealing with any transitory problems communicating with the target. As a result, ...",t:"Ingest Result Handlers"},"23":{i:0.00224680823440661,u:"../Content/Tutorial/CompleteSynchronize/Introduction.htm",a:"This section demonstrates code for a connector\u0027s synchronize action. During a complete synchronize, a connector ingests every document in a repository, regardless of whether the documents have changed since the last synchronize. \n            To avoid requiring additional dependencies, the sample ...",t:"A Complete Synchronize Action"},"24":{i:0.0014581215976652,u:"../Content/Tutorial/CompleteSynchronize/SampleCode_Cpp.htm",a:"The following sample code demonstrates a complete synchronize action. The synchronize action in this example generates documents for integers from 2 up to a configured limit IntegerLimit.  Each document contains some properties of the integer as metadata. The connector.hpp header file defines the ...",t:"Sample Code for the Synchronize Action"},"25":{i:0.000540044625242238,u:"../Content/Tutorial/CompleteSynchronize/RunConnector.htm",a:"You can set up the connector using the instructions in  Run the Connector . SimpleSynchronize.dll must be in the connector directory, and you must set the following parameters in connectorLibCpp.cfg:        ConnectorLibrary=SimpleSynchronize This example connector ingests a document for each integer ...",t:"Set up and Run the Connector"},"26":{i:0.000540044625242238,u:"../Content/Tutorial/CompleteSynchronize/Stopping.htm",a:"A connector can be requested to stop at any time.  For example,  the connector might be running as a service that is stopped, it might receive an action=stop command to its service port, or a user might press CTRL+C in the connector’s console window.  The  sample code  calls the shouldStop method on ...",t:"Handle Stop Requests"},"27":{i:0.000540044625242238,u:"../Content/Tutorial/CompleteSynchronize/Full_Incremental_Sync.htm",a:"The synchronize action demonstrated in the  sample code  acts the same way every time it is called: the connector ingests every  document in the repository . This is called a full synchronize, and a connector would typically do this the first time the synchronize action is used. When the synchronize ...",t:"Full and Incremental Synchronize"},"28":{i:0.00157670683907364,u:"../Content/Tutorial/IncrementalSynchronize/Make_Synchronize_Incremental.htm",a:"This section shows how to make an incremental synchronize action. An incremental synchronize is more efficient than running a full synchronize every time you need to synchronize with the information in the repository. The first time you run the synchronize action, the connector ingests all of the ...",t:"Make an Incremental Synchronize Action"},"29":{i:0.000540044625242238,u:"../Content/Tutorial/IncrementalSynchronize/Incremental_Synchronize.htm",a:"The incremental synchronize implemented by the sample code in   the IncrementalSynchronize project  works by maintaining the following datastore table: Reference LastModified PendingAction Seen ... ... ... ... The connector adds one row to the table for every file that it finds in the repository.  ...",t:"Incremental Synchronize"},"30":{i:0.000540044625242238,u:"../Content/Tutorial/IncrementalSynchronize/Incremental_Synchronize_Example.htm",a:"This section describes the connector in operation. Cycle 1 To begin with, the datastore table is empty. The “data” directory (the repository from which the sample connector retrieves data) contains three files:        File1.txt\n       File2.txt\n       File3.txt When the synchronize action runs, the ...",t:"Incremental Synchronize Example"},"31":{i:0.000540044625242238,u:"../Content/Tutorial/IncrementalSynchronize/Code_Structure.htm",a:"The sample code in  the IncrementalSynchronize project  is split into the following classes: MyState Handles access to the datastore and provides methods for updating and querying the table. MySynchronize Handles the synchronize action and depends upon MyState. MyConnector This is the main connector ...",t:"Sample Code Structure"},"32":{i:0.000540044625242238,u:"../Content/Tutorial/Actions_Intro.htm",a:"So far this document has focused on implementing the synchronize fetch action, but a connector can implement other fetch actions in addition to, or instead of, synchronize.  We have already seen how to implement synchronize by overriding the synchronize method in ConnectorBase. ConnectorBase also ...",t:"Implement Other Actions"},"33":{i:0.000999083111453719,u:"../Content/Tutorial/Actions_RetrieveDocuments.htm",a:"The following table lists the fetch actions that retrieve information from a repository. Action Description Method to override action=fetch\u0026fetchaction=synchronize Sends ingest commands to the ingest target to bring it up to date with what is contained the repository. synchronize ...",t:"Retrieve Documents from a Repository"},"34":{i:0.000540044625242238,u:"../Content/Tutorial/Actions_UpdateRepository.htm",a:"The following table lists fetch actions that update documents in a repository. Action Description Method to override /action=fetch\u0026fetchaction=Delete Delete specified documents from the repository. deleteDocs /action=fetch\u0026fetchaction=Insert Insert a document or documents into a repository. insert ...",t:"Update Documents in a Repository"},"35":{i:0.000540044625242238,u:"../Content/Tutorial/Actions_Identifiers.htm",a:"\n            The identifiers fetch action provides information that can be used to browse a repository. It retrieves a list of documents that are present in the repository and generates an identifier for each document. Action Description Method to override /action=fetch\u0026fetchaction=Identifiers ...",t:"Browse a Repository"},"36":{i:0.000540044625242238,u:"../Content/Tutorial/Actions_Stub.htm",a:"\n            The stub fetch action inserts a stub into a repository. A stub is a link to a document in another repository. An application might use your connector to insert a stub when a document is moved to another repository or is deleted. The stub can point to the new location, or in the case ...",t:"Insert a Stub into a Repository"},"37":{i:0.000540044625242238,u:"../Content/Tutorial/Actions_RetrieveGroups.htm",a:"The SynchronizeGroups fetch action retrieves group information from a repository. This is discussed in more detail in  Mapped Security . Action Description Method to override action=fetch\u0026fetchaction=SynchronizeGroups Updates a group server with user, group and group membership information from the ...",t:"Retrieve Group Information from a Repository"},"38":{i:0.000540044625242238,u:"../Content/Tutorial/Actions_GetUri.htm",a:"A connector\u0027s GetUri action takes a document identifier and returns a URI for the document in the repository. Before you implement the GetUri action, enable the action by updating the features() function on the connector so that it returns Features::get_uri:         Features::feature_type ...",t:"Retrieve the URI of a Document"},"39":{i:0.000540044625242238,u:"../Content/Tutorial/Actions_CustomFetch.htm",a:"You can implement custom fetch actions in a ConnectorLib C++ connector. Action Description Method to override action=Fetch\u0026FetchAction=MyAction Perform custom fetch actions on a repository. customFetch First add the custom_fetch feature to the list of supported features returned by the features ...",t:"Implement Custom Fetch Actions"},"40":{i:0.000540044625242238,u:"../Content/Tutorial/Actions_Custom.htm",a:"You can implement custom actions in a ConnectorLib C++ connector. Action Description Method to override action=MyAction Perform custom actions on a repository. Custom First add the custom feature to the list of supported features returned by the features function on ConnectorBase:        ...",t:"Implement Custom Actions"},"41":{i:0.000999083111453719,u:"../Content/Tutorial/Security/Security_Introduction.htm",a:"Documents in a repository can often be viewed only by authenticated users, and different users are allowed to view different documents.  In this case you might want any output from IDOL (for example, search results) to  show only documents that a user has permission to see.  This can be achieved by ...",t:"Mapped Security"},"42":{i:0.000823118557830746,u:"../Content/Tutorial/Security/AccessControlLists.htm",a:"An Access Control List (ACL) is a string of text that specifies who is allowed to view a document.  Connectors can add an ACL to a document field, usually AUTONOMYMETADATA, for every document that is ingested. This section describes an “NT Style” ACL, which is used in conjunction with the  IDOL ...",t:"Access Control Lists"},"43":{i:0.00152277030340827,u:"../Content/Tutorial/Security/Security_Groups.htm",a:"ACLs are often expressed in terms of users and groups. To determine whether a user can access a document, IDOL must know which security groups a user belongs to.  IDOL requests this information from a group server such as OmniGroupServer. The group server can retrieve the group membership ...",t:"Groups"},"44":{i:0.000823118557830746,u:"../Content/Tutorial/Security/SynchronizeGroups.htm",a:"As described in  Groups , it is sometimes necessary for a connector to provide group membership information to a group server. OmniGroupServer might be configured to store group information from a repository with the following settings: ...",t:"SynchronizeGroups"},"45":{i:0.000540044625242238,u:"../Content/Tutorial/ConnectorLib_Features.htm",a:"Logging, Configuration, and Temporary Files This section describes further useful features of ConnectorLib C++.",t:"Logging, Configuration, and Temporary Files"},"46":{i:0.000540044625242238,u:"../Content/Tutorial/Logging.htm",a:"All of the fetch action methods you can override in ConnectorBase are passed a task object with a Log object accessible with task.log()        task.log().always(\"This message is always logged\");\n       task.log().critical(\"This is logged at the critical level\");\n       task.log().error(\"Errors are ...",t:"Write Messages to the Log"},"47":{i:0.000540044625242238,u:"../Content/Tutorial/ReadConfiguration.htm",a:"All of the fetch action methods you can override in ConnectorBase are passed a task object that has a taskConfig() that returns the configuration for the task. The task configuration returned by the methods of the TaskConfig object  can be different to what is specified in the configuration file. ...",t:"Read Configuration Parameters"},"48":{i:0.000540044625242238,u:"../Content/Tutorial/CreateTempFiles.htm",a:"Your connector might need to create temporary files.  The task objects have a  tempDirectory() function  that provides the path of the directory to use for storing temporary files. The task object also provides a getTempFilename function to create a unique temporary file name:        std::string ...",t:"Create Temporary Files"},"49":{i:0.000693057453979398,u:"../Content/Tutorial/ProgressReporting.htm",a:"The synchronize action is typically used to retrieve all data from a repository. This could take seconds, hours, or even days to complete. You might therefore decide to give the user an indication of how much progress the connector has made and how much work there is left to do. This section ...",t:"Progress Reporting"},"50":{i:0.000769563868347978,u:"../Content/Tutorial/ProgressReporting_Intro.htm",a:"Progress information for a synchronize action can be retrieved using the following HTTP command, sent to the connector\u0027s ACI port: http://host:port/action=QueueInfo\u0026QueueName=Fetch\u0026QueueAction=Progress\u0026Token=token The  QueueInfo  action returns a report of the progress: \u003cautnresponse\u003e\n  ...",t:"Introduction"},"51":{i:0.000769563868347978,u:"../Content/Tutorial/ProgressReporting_Basic.htm",a:"FetchTask has a function called taskStage() that allows you to report progress for the synchronize action. The following example demonstrates basic progress reporting:    task.taskStage().setMaximum(20);\n   for (int ii = 0; ii \u003c 20; ++ii)\n   {\n      // Do work\n      ...",t:"Basic Progress"},"52":{i:0.000540044625242238,u:"../Content/Tutorial/ProgressReporting_Stages.htm",a:"Instead of updating the progress of the task stage directly, you can split it into multiple child stages. This provides more detail in the  progress report . Add Stages Each stage is given a weight and a maximum value:    Stage stage1 = task.taskStage().addChild(\"Searching for new Documents\", 1, ...",t:"Progress with Stages"},"53":{i:0.000540044625242238,u:"../Content/Connector_Reference.htm",a:"Connector Reference This section describes the actions, configuration parameters, and Lua methods that you can use with any connector developed using the ConnectorLib C++ SDK.",t:"Connector Reference"},"54":{i:0.000540044625242238,u:"../Content/Actions/Actions.htm",a:" Actions This section describes the actions that you can use with your connector. Introduction to Actions Connector Actions Fetch Actions",t:" Actions"},"55":{i:0.000693057453979398,u:"../Content/Actions/_ACI_Actions_Intro.htm",a:"Actions allow you to query an ACI server  and instruct it to perform a variety of operations. All actions must be sent to the server  Port . The configured authorization roles determine which users can send which actions to the port. See  Authorization Roles Configuration Parameters . The general ...",t:"Introduction to Actions"},"56":{i:0.000540044625242238,u:"../Content/Actions/Synchronous_and_Asynchro.htm",a:"Some actions are synchronous and others are asynchronous. A connector does not respond to a synchronous action until it has completed the request. The result of the action is in the response to the request. A connector responds to an asynchronous action immediately. The request is added to a queue ...",t:"Synchronous and Asynchronous Actions"},"57":{i:0.000693057453979398,u:"../Content/Actions/Connector/_CN_Actions_Connector.htm",a:"This section describes the actions that are supported by the connector. The connector also supports the Fetch action. For information about using the Fetch action, see  Fetch Actions . The sample HTTP requests in this section are split across multiple lines for readability. When you use these ...",t:"Connector Actions"},"58":{i:0.000540044625242238,u:"../Content/Actions/General/_ACI_Admin.htm",a:"Opens the IDOL Admin interface for the component that you use to call the action. This interface allows you to view data for the component and provides some administrative actions. To use this action, you must have an admin.dat file available for the component. You can configure the location of this ...",t:"Admin"},"59":{i:0.00131602767148198,u:"../Content/Actions/General/_ACI_BackupServer.htm",a:"The BackupServer action creates a backup that can be used to restore the server\u0027s state. The backup includes: details of actions that have been queued, are running, and have finished. a copy of the configuration file. information about the files that the connector has retrieved. ConnectorLib C++ ...",t:"BackupServer"},"60":{i:0.000540044625242238,u:"../Content/Actions/Connector/_CN_GetUri.htm",a:"\n            This action accepts a document identifier and returns a URI to the document in the repository. /action=GetUri\u0026Identifier=...\n             [\u0026Redirect=true] Type: Synchronous Parameter Name Description Required Identifier The identifier of a document. The connector returns a URI that can ...",t:"GetUri"},"61":{i:0.00360020707023554,u:"../Content/Actions/Connector/_CN_PauseSchedules.htm",a:"Temporarily stops the connector starting scheduled tasks. Any tasks that are currently running are allowed to finish but the connector will not start tasks that are scheduled to start.  Type: Synchronous Parameter Name Description Required Sections A comma-separated list of task schedules to pause. ...",t:"PauseSchedules"},"62":{i:0.000540044625242238,u:"../Content/Actions/Connector/_CN_PurgeDatastore.htm",a:"This action instructs the connector to delete the datastore for a fetch task. If any synchronize actions are running, the connector waits for them to finish before deleting the datastore. You might want to delete the datastore for a fetch task if you have modified the task configuration and you need ...",t:"PurgeDatastore"},"63":{i:0.023571779543859,u:"../Content/Actions/General/_ACI_QueueInfo.htm",a:"The QueueInfo action provides information about the asynchronous actions that the ACI server has queued, is processing, or has finished. You can use the QueueInfo action to: pause and resume processing the queued actions cancel a queued action change the priority of a queued action retrieve the ...",t:"QueueInfo"},"64":{i:0.00214788684805653,u:"../Content/Actions/General/_ACI_RestoreServer.htm",a:"The RestoreServer action restores a server’s state from a backup created by the BackupServer action. After using the RestoreServer action, you must restart the server. Type: Synchronous Parameter Name Description ActionID A string to use to identify an ACI action. Filename The path of the backup ...",t:"RestoreServer"},"65":{i:0.00360020707023554,u:"../Content/Actions/Connector/_CN_ResumeSchedules.htm",a:"Instructs the connector to resume starting scheduled tasks, for task schedules that have been paused by the action   PauseSchedules . Type: Synchronous Parameter Name Description Required Sections A comma-separated list of task schedules that you want to resume.  Specify the names of the tasks as ...",t:"ResumeSchedules"},"66":{i:0.000540044625242238,u:"../Content/Actions/Connector/_CN_StopFetch.htm",a:"This action requests all active asynchronous Fetch actions or a particular asynchronous Fetch action to stop. http://host:port/action=StopFetch\n\t\t          [\u0026Token=Fetch_Action_Token] Type: Synchronous Parameter Name Description Required Token The token of the asynchronous Fetch action to request to ...",t:"StopFetch"},"67":{i:0.000540044625242238,u:"../Content/Actions/Connector/_CN_TaskList.htm",a:"This action returns a list of the fetch tasks that are configured in the connector\u0027s configuration file, and fetch tasks that the connector ran as a result of receiving a fetch action with a configuration included in the config action parameter. The connector returns (if applicable): The name of the ...",t:"TaskList"},"68":{i:0.000540044625242238,u:"../Content/Actions/Connector/_CN_View.htm",a:"The View action retrieves a single document and returns it.\n         http://host:port/action=View\n                  [\u0026Config=\u003cBase64_Config\u003e]\n                   \u0026Identifier=Identifier\n                  [\u0026NoACI=True/False]\n                  [\u0026Override_Config_Parameters=...] Type: Synchronous ...",t:"View"},"69":{i:0.00128215704404223,u:"../Content/Actions/Fetch/_CN_Action_Fetch.htm",a:"This section describes the fetch actions that are supported by the connector. All of the actions in this section are available through action=Fetch. The sample HTTP requests in this section are split across multiple lines for readability. When using these requests, the whole request must be on one ...",t:"Fetch Actions"},"70":{i:0.000540044625242238,u:"../Content/Actions/Fetch/_CN_Collect.htm",a:"\n            This action retrieves documents from a repository and sends the documents to a specified location. You can save the documents to disk or add them to the ingest queue. You must specify the documents that you want to collect by their identifiers.\n        Type: Asynchronous Parameter Name ...",t:"Collect"},"71":{i:0.000540044625242238,u:"../Content/Actions/Fetch/_CN_DeleteRemove.htm",a:"This action deletes documents from a repository by their identifiers. Remove and delete are different names for the same action. Type: Asynchronous Parameter Name Description Required Config A base-64 encoded configuration. The configuration parameters that are set override the same parameters in ...",t:"Delete/Remove"},"72":{i:0.000540044625242238,u:"../Content/Actions/Fetch/_CN_Hold.htm",a:"\n            The Hold action places a hold on a document or documents in the repository. When a document has been placed on hold, it cannot be deleted or modified by a regular user.\n         \n            Specify the documents to hold by their identifiers. Type: Asynchronous Parameter Name ...",t:"Hold"},"73":{i:0.000540044625242238,u:"../Content/Actions/Fetch/Insert.htm",a:"\n            This action inserts a document or documents into a repository.\n        Type: Asynchronous Parameter Name Description Required Config A base-64 encoded configuration. The configuration parameters that are set override the same parameters in the connector\u0027s configuration file. No ...",t:"Insert"},"74":{i:0.000540044625242238,u:"../Content/Actions/Fetch/_CN_ReleaseHold.htm",a:"The ReleaseHold action releases a document that has been placed on hold.\n         Documents are specified by their identifier.\n        Type: Asynchronous Parameter Name Description Required Config A base-64 encoded configuration. The configuration parameters that are set override the same parameters ...",t:"ReleaseHold"},});